###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for silc-toolkit MDVSA-2008:158 (silc-toolkit)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830413);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:158");
  script_cve_id("CVE-2008-1227", "CVE-2008-1552");
  script_name(english: "Mandriva Update for silc-toolkit MDVSA-2008:158 (silc-toolkit)");
  desc["english"] = "

  Vulnerability Insight:

  A vulnerability was found in the SILC toolkit before version 1.1.5
  that allowed a remote attacker to cause a denial of service (crash),
  or possibly execute arbitrary code via long input data (CVE-2008-1227).
  
  A vulnerability was found in the SILC toolkit before version 1.1.7
  that allowed a remote attacker to execute arbitrary code via a crafted
  PKCS#2 message (CVE-2008-1552).
  
  The updated packages have been patched to correct these issues.

  Affected Software/OS:
  silc-toolkit on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-07/msg00051.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of silc-toolkit");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"libsilc", rpm:"libsilc~1.1_2~1.1.2~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsilcclient", rpm:"libsilcclient~1.1_2~1.1.2~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"silc-toolkit", rpm:"silc-toolkit~1.1.2~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"silc-toolkit-devel", rpm:"silc-toolkit-devel~1.1.2~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64silc", rpm:"lib64silc~1.1_2~1.1.2~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64silcclient", rpm:"lib64silcclient~1.1_2~1.1.2~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}