###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_memcached_info_disclosure_vuln.nasl 2114 2009-05-14 21:25:29Z may $
#
# Memcached Information Disclosure Vulnerabilities
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800715);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1255", "CVE-2009-1494");
  script_bugtraq_id(34756);
  script_name(english:"Memcached Information Disclosure Vulnerabilities");
  desc["english"] = "

  Overview: The host is running Memcached and is prone to Information Disclosure
  Vulnerabilities.

  Vulnerability Insight:
  - Error in process_stat function discloses the contents of /proc/self/maps in
    response to a stats maps command.
  - Error in process_stat function which discloses memory allocation statistics
    in response to a stats malloc command.

  Impact:
  Successful exploitation will let the attacker craft malicious commands and
  pass it to the vulnerable functions to gain sensitive information about the
  application i.e. disclosure of locations of memory regions and defeat ASLR
  protections, by sending a command to the daemon's TCP port.

  Affected Software/OS:
  Memcached version prior to 1.2.8

  Fix:
  Upgrade to the latest version 1.2.8
  http://www.danga.com/memcached

  References:
  http://secunia.com/advisories/34915
  http://www.vupen.com/english/advisories/2009/1196
  http://www.positronsecurity.com/advisories/2009-001.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Memcached");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"General");
  script_dependencies("gb_memcached_detect.nasl");
  script_require_keys("MemCached/Ver");
  exit(0);
}


include("version_func.inc");

memcachedVer = get_kb_item("MemCached/Ver");
if(memcachedVer == NULL){
  exit(0);
}

# Grep for Memcached version prior to 1.2.8
if(version_is_less(version:memcachedVer, test_version:"1.2.8")){
  security_warning(memPort);
}
