###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms08-030.nasl 0292 30 12:54:43Z sep $
#
# Bluetooth Stack Could Allow Remote Code Execution Vulnerability (951376)
#
# Authors:      Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800008);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-1453");
  script_bugtraq_id(29522);
  script_xref(name:"CB-A", value:"08-0099");
  script_name(english:"Bluetooth Stack Could Allow Remote Code Execution Vulnerability (951376)");
  desc["english"] = "
  Overview : This host has critical security update missing according to
  Microsoft Bulletin MS08-030.

  Vulnerability Insight :
  The flaw is caused due to an error in the Bluetooth stack when processing
  large number of service description requests.

  Impact: Successful exploitation could allow remote attackers to execute
  arbitrary code with elevated privileges by rapidly sending a large number
  of specially crafted SDP (Service Discovery Protocol) packets to the
  vulnerable system.

  Impact Level: System.
 
  Affected Software/OS: Microsoft Windows XP SP2/SP3.

  Fix : Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms08-030.mspx

  References:
  http://www.us-cert.gov/cas/techalerts/TA08-162B.html
  http://www.microsoft.com/technet/security/bulletin/ms08-030.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Hotfix and version of MS08-030");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_smb_func.inc");

# Check OS applicability. Only Windows XP is verified, Vista is affected as
# well but, not supported at this point in time.
if(hotfix_check_sp(xp:4) <= 0){
  exit(0);
}

function Get_FileVersion()
{
  sysFile = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                            item:"Install Path");
  if(!sysFile){
    exit(0);
  }
  
  sysFile += "\drivers\Bthport.sys";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysFile);
  file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:sysFile);
  
  soc = open_sock_tcp(port);
  if(!soc){
    exit(0);
  }
  
  r = smb_session_request(soc:soc, remote:name);
  if(!r)
  { 
    close(soc);
    exit(0);
  }
  
  prot = smb_neg_prot(soc:soc);
  if(!prot)
  { 
    close(soc);
    exit(0);
  }
  
  r = smb_session_setup(soc:soc, login:login, password:pass,
                        domain:domain, prot:prot);
  if(!r)
  { 
    close(soc);
    exit(0);
  }

  uid = session_extract_uid(reply:r);
  r = smb_tconx(soc:soc, name:name, uid:uid, share:share);

  tid = tconx_extract_tid(reply:r);
  if(!tid)
  {
    close(soc);
    exit(0);
  }

  fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
  if(!fid)
  {
    close(soc);
    exit(0);
  }

  v = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, verstr:"prod",
                 offset:260000);
  close(soc);
  return v;
}


# Check for Hotfix 951376 (MS08-030). 
if(hotfix_missing(name:"951376") == 0){
  exit(0);
}

SP = get_kb_item("SMB/WinXP/ServicePack");
if("Service Pack 2" >< SP)
{
  sysVer = Get_FileVersion();
  if(sysVer == NULL){
    exit(0);
  }

  # Grep for Bthport.sys version < 5.1.2600.3389
  if(egrep(pattern:"^5\.0?1\.2600\.([0-2]?[0-9]?[0-9]?[0-9]|3[0-2][0-9][0-9]" +
                   "|33([0-7][0-9]|8[0-8]))$",
           string:sysVer)){
    security_hole(0);
  }
  exit(0);
}

else if("Service Pack 3" >< SP)
{
  sysVer = Get_FileVersion();
  if(sysVer == NULL){
      exit(0);
  }

  # Grep for Bthport.sys version < 5.1.2600.5620
  if(egrep(pattern:"5\.0?1\.2600\.([0-4]?[0-9]?[0-9]?[0-9]|5[0-5][0-9][0-9]|" +
                   "56[01][0-9])$",
           string:sysVer)){
    security_hole(0);
  }
}
