###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_quiksoft_easymail_obj_actvx_bof_vuln.nasl 867 2009-03-11 13:20:24Z mar $
#
# QuikSoft EasyMail Objects ActiveX Control BOF Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800535);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6447");
  script_bugtraq_id(32722);
  script_name(english:"QuikSoft EasyMail Objects ActiveX Control BOF Vulnerability");
  desc["english"] = "

  Overview: This host is installed with QuikSoft EasyMail Objects ActiveX
  Control and is prone to buffer overflow vulnerability.

  Vulnerability Insight:
  Flaw exists in CreateStore method in emmailstore.dll file, which fails to
  perform adequate boundary checks on user-supplied data.

  Impact:
  Attackers may exploit this issue by executing arbitrary code in the context
  of a Web page and can cause buffer overflow.

  Impact Level: Application

  Affected Software/OS:
  QuikSoft EasyMail MailStore with emmailstore.dll version 6.5.0.3 on Windows

  Fix: No solution or patch is available as on 13th March 2009, Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.quiksoft.com/

  References:
  http://www.milw0rm.com/exploits/7402
  http://support.microsoft.com/kb/240797
  http://xforce.iss.net/xforce/xfdb/47207

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.1
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the emmailstore.dll version");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Buffer overflow");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Quiksoft\EasyMail Objects")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  emoName = registry_get_sz(key:key + item, item:"DisplayName");
  if("EasyMail Objects" >< emoName)
  {
    dllPath = registry_get_sz(key:key + item, item:"InstallLocation");
    if(dllPath != NULL)
    {
      dllPath = dllPath + "emmailstore.dll";
      share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
      file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath);

      dllVer = GetVer(file:file, share:share);
      if(version_is_less_equal(version:dllVer, test_version:"6.5.0.3")){
        security_hole(0);
      }
    }
    exit(0);
  }
}
