###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_seportal_sql_inj_vuln.nasl 522 2008-11-24 16:33:33Z nov $
#
# SePortal poll.php SQL Injection Vulnerability
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800143);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5191");
  script_bugtraq_id(29996);
  script_name(english:"SePortal poll.php SQL Injection Vulnerability");
  desc["english"] = "

  Overview: The host is running SePortal which is prone to SQL Injection
  Vulnerability.

  Vulnerability Insight:
  Input passed to the poll_id parameter in poll.php and to sp_id parameter
  in staticpages.php files are not properly sanitised before being used in
  an SQL query.

  Impact:
  Successful attack could lead to execution of arbitrary SQL queries.

  Impact Level: Application

  Affected Software/OS:
  SePortal Version 2.4 and prior on all running platform.

  Fix: No solution/patch is available as on 27th November, 2008. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.seportal.org/

  References:
  http://secunia.com/advisories/30865
  http://www.milw0rm.com/exploits/5960

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of SePortal");
  script_category(ACT_MIXED_ATTACK);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"CGI abuses");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

foreach dir (make_list("/seportal", cgi_dirs()))
{
  sndReq = http_get(item:string(dir + "/index.php"), port:port);
  rcvRes = http_keepalive_send_recv(port:port,data:sndReq,bodyonly:1);
  if(rcvRes == NULL){
    exit(0);
  }

  if("SePortal" >< rcvRes)
  {
    sepVer = eregmatch(string:rcvRes, pattern:"SePortal<.+ ([0-9]\.[0-9.]+)");
    if(sepVer[1] != NULL)
    {
      # Check for SePortal Version <= 2.4
      if(version_is_less_equal(version:sepVer[1], test_version:"2.4")){
        security_hole(0);
      }
    }
    exit(0);
  }
}
