###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for krb5 SUSE-SA:2007:004
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850089);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-004");
  script_cve_id("CVE-2006-6143", "CVE-2006-6144");
  script_name(english: "SuSE Update for krb5 SUSE-SA:2007:004");
  desc["english"] = "

  Vulnerability Insight:

  Various bugs in the Kerberos5 libraries and tools were fixed which
  could be used by remote attackers to crash and potentially execute
  code in kadmind.

  - CVE-2006-6144 / MITKRB5-SA-2006-002: the RPC library could call an
  uninitialized function pointer, which created a security
  vulnerability for kadmind.

  - CVE-2006-6143 / MITKRB5-SA-2006-003: the GSS-API mechglue layer
  could fail to initialize some output pointers, causing callers to
  attempt to free uninitialized pointers.  This caused a security
  vulnerability in kadmind.

  Impact:
  remote denial of service

  Affected Software/OS:
  krb5 on openSUSE 10.2, SUSE LINUX 10.1, SUSE SLED 10, SUSE SLES 10

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_04_krb5.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of krb5");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "SLED10")
{

  if(isrpmvuln(pkg:"krb5", rpm:"krb5~1.4.3~19.7", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-32bit", rpm:"krb5-32bit~1.4.3~19.7", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-server", rpm:"krb5-server~1.4.3~19.7", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"krb5", rpm:"krb5~1.5.1~23.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-server", rpm:"krb5-server~1.5.1~23.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-32bit", rpm:"krb5-32bit~1.5.1~23.2", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES10")
{

  if(isrpmvuln(pkg:"krb5", rpm:"krb5~1.4.3~19.7", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-32bit", rpm:"krb5-32bit~1.4.3~19.7", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-server", rpm:"krb5-server~1.4.3~19.7", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"krb5", rpm:"krb5~1.4.3~19.7", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-server", rpm:"krb5-server~1.4.3~19.7", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}