###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for php4,php5 SUSE-SA:2007:020
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850075);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-020");
  script_cve_id("CVE-2006-6383", "CVE-2007-0906", "CVE-2007-0907", "CVE-2007-0908", "CVE-2007-0909", "CVE-2007-0910", "CVE-2007-0911", "CVE-2007-1380", "CVE-2007-1399");
  script_name(english: "SuSE Update for php4,php5 SUSE-SA:2007:020");
  desc["english"] = "

  Vulnerability Insight:

  Multiple bugs have been fixed in the PHP4 and PHP5 script interpreters.

  These include the following security related problems:

  CVE-2007-0906: Multiple buffer overflows in PHP before 5.2.1
  allow attackers to cause a denial of service and possibly execute
  arbitrary code via unspecified vectors in the (1) session, (2) zip,
  (3) imap, and (4) sqlite extensions; (5) stream filters; and the (6)
  str_replace, (7) mail, (8) ibase_delete_user, (9) ibase_add_user,
  and (10) ibase_modify_user functions.

  CVE-2007-0907: Buffer underflow in PHP before 5.2.1 allows attackers
  to cause a denial of service via unspecified vectors involving the
  sapi_header_op function.

  CVE-2007-0908: The wddx extension in PHP before 5.2.1 allows remote
  attackers to obtain sensitive information via unspecified vectors.

  CVE-2007-0909: Multiple format string vulnerabilities in PHP before
  5.2.1 might allow attackers to execute arbitrary code via format string
  specifiers to (1) all of the *print functions on 64-bit systems, and
  (2) the odbc_result_all function.

  CVE-2007-0910: Unspecified vulnerability in PHP before 5.2.1 allows
  attackers to &quot;clobber&quot; certain super-global variables via unspecified
  vectors.

  CVE-2007-0911: Off-by-one error in the str_ireplace function in PHP
  5.2.1 might allow context-dependent attackers to cause a denial of
  service (crash).

  CVE-2006-6383: PHP 5.2.0 and 4.4 allows local users to bypass safe_mode
  and open_basedir restrictions via a malicious path and a null byte
  before a &quot;;&quot; in a session_save_path argument, followed by an allowed
  path, which causes a parsing inconsistency in which PHP validates
  the allowed path but sets session.save_path to the malicious path.


  This security update also fixes some bugs reported by the Month of
  PHP bugs project:

  MOPB-10-2007 / CVE-2007-1380: The php_binary serialization handler
  in the session extension in PHP before 4.4.5, and 5.x before 5.2.1,
  allows context-dependent attackers to obtain sensitive information
  (memory contents) via a serialized variable entry with a large length
  value, which triggers a buffer over-read.

  MOPB-16-2007 / CVE-2007-1399: Stack-based buffer overflow in the zip://
  URL wrapper in PECL ZIP 1.8.3 and earlier, as bundled with PHP 5.2.0
  and 5.2.1, allows remote attackers to execute arbitrary code via a
  long zip:// URL, as demonstrated by actively triggering URL access
  from a remote PHP interpreter via avatar upload or blog pingback.
  Note that this problem is caught by the FORTIFY SOURCE extension in
  SUSE Linux 10.0 and newer products and just leads to a controlled
  abort of the PHP interpreter.

  Impact:
  remote code execution

  Affected Software/OS:
  php4,php5 on SUSE LINUX 10.1, openSUSE 10.2, SuSE Linux Enterprise Server 8, SUSE SLES 9, Open Enterprise Server, Novell Linux POS 9, SUSE SLES 10

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_20_php.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of php4,php5");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"apache2-mod_php5", rpm:"apache2-mod_php5~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5", rpm:"php5~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-bcmath", rpm:"php5-bcmath~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-curl", rpm:"php5-curl~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-dba", rpm:"php5-dba~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-devel", rpm:"php5-devel~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-dom", rpm:"php5-dom~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-exif", rpm:"php5-exif~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-fastcgi", rpm:"php5-fastcgi~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-ftp", rpm:"php5-ftp~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-gd", rpm:"php5-gd~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-iconv", rpm:"php5-iconv~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-imap", rpm:"php5-imap~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-ldap", rpm:"php5-ldap~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-mbstring", rpm:"php5-mbstring~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-mhash", rpm:"php5-mhash~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-mysql", rpm:"php5-mysql~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-odbc", rpm:"php5-odbc~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-pear", rpm:"php5-pear~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-pgsql", rpm:"php5-pgsql~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-soap", rpm:"php5-soap~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-sysvmsg", rpm:"php5-sysvmsg~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-sysvshm", rpm:"php5-sysvshm~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-wddx", rpm:"php5-wddx~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-xmlrpc", rpm:"php5-xmlrpc~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-zip", rpm:"php5-zip~5.2.0~12", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES10")
{

  if(isrpmvuln(pkg:"apache2-mod_php5", rpm:"apache2-mod_php5~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5", rpm:"php5~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-bcmath", rpm:"php5-bcmath~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-curl", rpm:"php5-curl~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-dba", rpm:"php5-dba~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-devel", rpm:"php5-devel~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-dom", rpm:"php5-dom~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-exif", rpm:"php5-exif~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-fastcgi", rpm:"php5-fastcgi~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-ftp", rpm:"php5-ftp~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-gd", rpm:"php5-gd~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-iconv", rpm:"php5-iconv~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-imap", rpm:"php5-imap~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-ldap", rpm:"php5-ldap~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-mbstring", rpm:"php5-mbstring~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-mhash", rpm:"php5-mhash~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-mysql", rpm:"php5-mysql~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-odbc", rpm:"php5-odbc~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-pear", rpm:"php5-pear~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-pgsql", rpm:"php5-pgsql~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-wddx", rpm:"php5-wddx~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-mysqli", rpm:"php5-mysqli~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-pdo", rpm:"php5-pdo~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-soap", rpm:"php5-soap~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-sysvmsg", rpm:"php5-sysvmsg~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-xmlrpc", rpm:"php5-xmlrpc~5.1.2~29.25.3", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESSr8")
{

  if(isrpmvuln(pkg:"mod_php4", rpm:"mod_php4~4.2.2~522", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_php4-core", rpm:"mod_php4-core~4.2.2~522", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_php4-devel", rpm:"mod_php4-devel~4.2.2~522", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_php4-servlet", rpm:"mod_php4-servlet~4.2.2~522", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"apache-mod_php4", rpm:"apache-mod_php4~4.3.4~43.75", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-mod_php4", rpm:"apache2-mod_php4~4.3.4~43.75", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_php4-core", rpm:"mod_php4-core~4.3.4~43.75", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_php4-servlet", rpm:"mod_php4-servlet~4.3.4~43.75", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4", rpm:"php4~4.3.4~43.75", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-devel", rpm:"php4-devel~4.3.4~43.75", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-exif", rpm:"php4-exif~4.3.4~43.75", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-fastcgi", rpm:"php4-fastcgi~4.3.4~43.75", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-imap", rpm:"php4-imap~4.3.4~43.75", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-mhash", rpm:"php4-mhash~4.3.4~43.75", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-mysql", rpm:"php4-mysql~4.3.4~43.75", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-pear", rpm:"php4-pear~4.3.4~43.75", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-servlet", rpm:"php4-servlet~4.3.4~43.75", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-session", rpm:"php4-session~4.3.4~43.75", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-sysvshm", rpm:"php4-sysvshm~4.3.4~43.75", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-unixODBC", rpm:"php4-unixODBC~4.3.4~43.75", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-wddx", rpm:"php4-wddx~4.3.4~43.75", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"apache-mod_php4", rpm:"apache-mod_php4~4.3.4~43.75", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-mod_php4", rpm:"apache2-mod_php4~4.3.4~43.75", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_php4-core", rpm:"mod_php4-core~4.3.4~43.75", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_php4-servlet", rpm:"mod_php4-servlet~4.3.4~43.75", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4", rpm:"php4~4.3.4~43.75", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-devel", rpm:"php4-devel~4.3.4~43.75", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-exif", rpm:"php4-exif~4.3.4~43.75", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-fastcgi", rpm:"php4-fastcgi~4.3.4~43.75", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-imap", rpm:"php4-imap~4.3.4~43.75", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-mhash", rpm:"php4-mhash~4.3.4~43.75", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-mysql", rpm:"php4-mysql~4.3.4~43.75", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-pear", rpm:"php4-pear~4.3.4~43.75", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-servlet", rpm:"php4-servlet~4.3.4~43.75", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-session", rpm:"php4-session~4.3.4~43.75", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-sysvshm", rpm:"php4-sysvshm~4.3.4~43.75", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-unixODBC", rpm:"php4-unixODBC~4.3.4~43.75", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-wddx", rpm:"php4-wddx~4.3.4~43.75", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"apache-mod_php4", rpm:"apache-mod_php4~4.3.4~43.75", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-mod_php4", rpm:"apache2-mod_php4~4.3.4~43.75", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_php4-core", rpm:"mod_php4-core~4.3.4~43.75", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_php4-servlet", rpm:"mod_php4-servlet~4.3.4~43.75", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4", rpm:"php4~4.3.4~43.75", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-devel", rpm:"php4-devel~4.3.4~43.75", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-exif", rpm:"php4-exif~4.3.4~43.75", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-fastcgi", rpm:"php4-fastcgi~4.3.4~43.75", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-imap", rpm:"php4-imap~4.3.4~43.75", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-mhash", rpm:"php4-mhash~4.3.4~43.75", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-mysql", rpm:"php4-mysql~4.3.4~43.75", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-pear", rpm:"php4-pear~4.3.4~43.75", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-servlet", rpm:"php4-servlet~4.3.4~43.75", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-session", rpm:"php4-session~4.3.4~43.75", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-sysvshm", rpm:"php4-sysvshm~4.3.4~43.75", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-unixODBC", rpm:"php4-unixODBC~4.3.4~43.75", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php4-wddx", rpm:"php4-wddx~4.3.4~43.75", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"apache2-mod_php5", rpm:"apache2-mod_php5~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5", rpm:"php5~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-bcmath", rpm:"php5-bcmath~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-curl", rpm:"php5-curl~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-dba", rpm:"php5-dba~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-devel", rpm:"php5-devel~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-dom", rpm:"php5-dom~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-exif", rpm:"php5-exif~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-fastcgi", rpm:"php5-fastcgi~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-ftp", rpm:"php5-ftp~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-gd", rpm:"php5-gd~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-iconv", rpm:"php5-iconv~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-imap", rpm:"php5-imap~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-ldap", rpm:"php5-ldap~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-mbstring", rpm:"php5-mbstring~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-mhash", rpm:"php5-mhash~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-mysql", rpm:"php5-mysql~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-mysqli", rpm:"php5-mysqli~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-odbc", rpm:"php5-odbc~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-pear", rpm:"php5-pear~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-pgsql", rpm:"php5-pgsql~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-soap", rpm:"php5-soap~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-sysvmsg", rpm:"php5-sysvmsg~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-sysvshm", rpm:"php5-sysvshm~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-wddx", rpm:"php5-wddx~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php5-xmlrpc", rpm:"php5-xmlrpc~5.1.2~29.25.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}