###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for gpg SUSE-SA:2007:024
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850102);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-024");
  script_cve_id("CVE-2007-1263");
  script_name(english: "SuSE Update for gpg SUSE-SA:2007:024");
  desc["english"] = "

  Vulnerability Insight:

  When printing a text stream with a GPG signature it was possible
  for an attacker to create a stream with &quot;unsigned text, signed text&quot;
  where both unsigned and signed text would be shown without distinction
  which one was signed and which part wasn't.

  This problem is tracked by the Mitre CVE ID CVE-2007-1263.

  The update introduces a new option --allow-multiple-messages to print
  out such messages in the future, by default it only prints and handles
  the first one.

  gpg2 and various clients using GPG to check digital signatures are
  affected too, but will be fixed separately.

  Impact:
  signature bypassing

  Affected Software/OS:
  gpg on SUSE LINUX 10.1, openSUSE 10.2, SuSE Linux Enterprise Server 8, SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SUSE SLED 10, SUSE SLES 10

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_24_gpg.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of gpg");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.4.5~24.4", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES10")
{

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.2.4~68.25", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.2.2rc1~128", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.0.7~195", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.4.2~23.16", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESSr8")
{

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.2.4~68.25", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.2.2rc1~128", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.0.7~195", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.4.2~23.16", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.2.4~68.25", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.2.2rc1~128", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.0.7~195", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.4.2~23.16", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.2.4~68.25", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.2.2rc1~128", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.0.7~195", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.4.2~23.16", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.2.4~68.25", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.2.2rc1~128", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.0.7~195", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.4.2~23.16", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.2.4~68.25", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.2.2rc1~128", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.0.7~195", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.4.2~23.16", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.4.2~23.16", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLED10")
{

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.2.4~68.25", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.2.2rc1~128", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.0.7~195", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gpg", rpm:"gpg~1.4.2~23.16", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}