###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for gnutls SUSE-SA:2008:046
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850049);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-046");
  script_cve_id("CVE-2008-1948", "CVE-2008-1949", "CVE-2008-1950");
  script_name(english: "SuSE Update for gnutls SUSE-SA:2008:046");
  desc["english"] = "

  Vulnerability Insight:

  Multiple security issues have been fixed in crypto framework gnutls:

  CVE-2008-1948 (GNUTLS-SA-2008-1-1): The _gnutls_server_name_recv_params
  function in lib/ext_server_name.c in libgnutls in gnutls-serv in
  GnuTLS before 2.2.4 does not properly calculate the number of Server
  Names in a TLS 1.0 Client Hello message during extension handling,
  which allows remote attackers to cause a denial of service (crash)
  or possibly execute arbitrary code via a zero value for the length of
  Server Names, which leads to a buffer overflow in session resumption
  data in the pack_security_parameters function.

  CVE-2008-1949 (GNUTLS-SA-2008-1-2): The _gnutls_recv_client_kx_message
  function in lib/gnutls_kx.c in libgnutls in gnutls-serv in GnuTLS
  before 2.2.4 continues to process Client Hello messages within a TLS
  message after one has already been processed, which allows remote
  attackers to cause a denial of service (NULL dereference and crash)
  via a TLS message containing multiple Client Hello messages,

  CVE-2008-1950 (GNUTLS-SA-2008-1-3):  Integer signedness error in
  the _gnutls_ciphertext2compressed function in lib/gnutls_cipher.c in
  libgnutls in GnuTLS before 2.2.4 allows remote attackers to cause a
  denial of service (buffer over-read and crash) via a certain integer
  value in the  Random field in an encrypted Client Hello message within
  a TLS record with an invalid Record Length, which leads to an invalid
  cipher padding length,

  openSUSE 11.0 was already shipped with fixed gnutls packages.

  Impact:
  remote code execution

  Affected Software/OS:
  gnutls on openSUSE 10.2, openSUSE 10.3, SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SUSE Linux Enterprise Desktop 10 SP1, SUSE Linux Enterprise Server 10 SP1, SUSE Linux Enterprise Desktop 10 SP2, SUSE Linux Enterprise 10 SP2 DEBUGINFO, SUSE Linux Enterprise Server 10 SP2

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_46_gnutls.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of gnutls");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.6.1~36.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.6.1~36.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-32bit", rpm:"gnutls-32bit~1.6.1~36.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel-32bit", rpm:"gnutls-devel-32bit~1.6.1~36.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.4.4~19", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.4.4~19", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-32bit", rpm:"gnutls-32bit~1.4.4~19", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel-32bit", rpm:"gnutls-devel-32bit~1.4.4~19", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.0.8~26.15", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.0.8~26.15", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.2.10~13.11", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.2.10~13.11", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-32bit", rpm:"gnutls-32bit~1.2.10~13.11", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel-32bit", rpm:"gnutls-devel-32bit~1.2.10~13.11", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.0.8~26.15", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.0.8~26.15", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.2.10~13.11", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.2.10~13.11", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-32bit", rpm:"gnutls-32bit~1.2.10~13.11", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel-32bit", rpm:"gnutls-devel-32bit~1.2.10~13.11", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.0.8~26.15", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.0.8~26.15", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.2.10~13.11", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.2.10~13.11", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-32bit", rpm:"gnutls-32bit~1.2.10~13.11", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel-32bit", rpm:"gnutls-devel-32bit~1.2.10~13.11", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.0.8~26.15", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.0.8~26.15", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.2.10~13.11", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.2.10~13.11", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-32bit", rpm:"gnutls-32bit~1.2.10~13.11", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel-32bit", rpm:"gnutls-devel-32bit~1.2.10~13.11", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.2.10~13.8.5", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.2.10~13.8.5", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-32bit", rpm:"gnutls-32bit~1.2.10~13.8.5", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel-32bit", rpm:"gnutls-devel-32bit~1.2.10~13.8.5", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP2")
{

  if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.0.8~26.15", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.0.8~26.15", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.2.10~13.11", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.2.10~13.11", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-32bit", rpm:"gnutls-32bit~1.2.10~13.11", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel-32bit", rpm:"gnutls-devel-32bit~1.2.10~13.11", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLEDe10SP2")
{

  if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.0.8~26.15", rls:"SLEDe10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.0.8~26.15", rls:"SLEDe10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.2.10~13.11", rls:"SLEDe10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.2.10~13.11", rls:"SLEDe10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-32bit", rpm:"gnutls-32bit~1.2.10~13.11", rls:"SLEDe10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel-32bit", rpm:"gnutls-devel-32bit~1.2.10~13.11", rls:"SLEDe10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP2")
{

  if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.0.8~26.15", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.0.8~26.15", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.2.10~13.11", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.2.10~13.11", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-32bit", rpm:"gnutls-32bit~1.2.10~13.11", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel-32bit", rpm:"gnutls-devel-32bit~1.2.10~13.11", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.2.10~13.8.5", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.2.10~13.8.5", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-32bit", rpm:"gnutls-32bit~1.2.10~13.8.5", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel-32bit", rpm:"gnutls-devel-32bit~1.2.10~13.8.5", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}