###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_tor_detect_win.nasl 942 2009-02-05 19:51:29Z feb $
#
# Tor Version Detection (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800351);
  script_version("$Revision: 1.0 $");
  script_name(english:"Tor Version Detection (Win)");
  desc["english"] = "
  Overview: This script detects the installed version of Tor and sets
  the result in KB.

  Risk factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set KB for the version of Tor");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

torName = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                              "\Uninstall\Tor", item:"DisplayName");
if("Tor" >< torName)
{
  torVer = eregmatch(pattern:"Tor ([0-9.]+)", string:torName);
  if(torVer[1] != NULL){
    set_kb_item(name:"Tor/Win/Ver", value:torVer[1]);
  }
}
