###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for pptpd vulnerabilities USN-459-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840143);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "459-2");
  script_cve_id("");
  script_name(english: "Ubuntu Update for pptpd vulnerabilities USN-459-2");
  desc["english"] = "

  Vulnerability Insight:

  USN-459-1 fixed vulnerabilities in pptpd.  However, a portion of the fix
  caused a regression in session establishment under Dapper for certain
  PPTP clients.  This update fixes the problem.
  
  We apologize for the inconvenience.
  
  Original advisory details:
  
  A flaw was discovered in the PPTP tunnel server. Remote attackers could
  send a specially crafted packet and disrupt established PPTP tunnels,
  leading to a denial of service.

  Affected Software/OS:
  pptpd vulnerabilities on Ubuntu 6.06 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-May/000532.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of pptpd vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"bcrelay", ver:"1.2.3-1ubuntu0.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pptpd", ver:"1.2.3-1ubuntu0.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}