###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for qt-x11-free vulnerability USN-495-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840043);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "495-1");
  script_cve_id("CVE-2007-3388");
  script_name(english: "Ubuntu Update for qt-x11-free vulnerability USN-495-1");
  desc["english"] = "

  Vulnerability Insight:

  Several format string vulnerabilities have been discovered in Qt
  warning messages. By causing an application to process specially
  crafted input data which triggered Qt warnings, this could be
  exploited to execute arbitrary code with the privilege of the user
  running the application.

  Affected Software/OS:
  qt-x11-free vulnerability on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-August/000570.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of qt-x11-free vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libqt3-compat-headers", ver:"3.3.8really3.3.7-0ubuntu5.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-headers", ver:"3.3.8really3.3.7-0ubuntu5.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-dev", ver:"3.3.8really3.3.7-0ubuntu5.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-mysql", ver:"3.3.8really3.3.7-0ubuntu5.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-odbc", ver:"3.3.8really3.3.7-0ubuntu5.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-psql", ver:"3.3.8really3.3.7-0ubuntu5.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-sqlite", ver:"3.3.8really3.3.7-0ubuntu5.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt", ver:"3.3.8really3.3.7-0ubuntu5.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt-x11-free-dbg", ver:"3.3.8really3.3.7-0ubuntu5.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-apps-dev", ver:"3.3.8really3.3.7-0ubuntu5.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-assistant", ver:"3.3.8really3.3.7-0ubuntu5.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-designer", ver:"3.3.8really3.3.7-0ubuntu5.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-dev-tools-compat", ver:"3.3.8really3.3.7-0ubuntu5.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-dev-tools-embedded", ver:"3.3.8really3.3.7-0ubuntu5.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-dev-tools", ver:"3.3.8really3.3.7-0ubuntu5.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-linguist", ver:"3.3.8really3.3.7-0ubuntu5.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-qtconfig", ver:"3.3.8really3.3.7-0ubuntu5.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-i18n", ver:"3.3.8really3.3.7-0ubuntu5.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-doc", ver:"3.3.8really3.3.7-0ubuntu5.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-examples", ver:"3.3.8really3.3.7-0ubuntu5.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libqt3-compat-headers", ver:"3.3.6-1ubuntu6.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-headers", ver:"3.3.6-1ubuntu6.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-dev", ver:"3.3.6-1ubuntu6.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-mysql", ver:"3.3.6-1ubuntu6.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-odbc", ver:"3.3.6-1ubuntu6.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-psql", ver:"3.3.6-1ubuntu6.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-sqlite", ver:"3.3.6-1ubuntu6.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt", ver:"3.3.6-1ubuntu6.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt-x11-free-dbg", ver:"3.3.6-1ubuntu6.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-apps-dev", ver:"3.3.6-1ubuntu6.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-assistant", ver:"3.3.6-1ubuntu6.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-designer", ver:"3.3.6-1ubuntu6.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-dev-tools-compat", ver:"3.3.6-1ubuntu6.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-dev-tools-embedded", ver:"3.3.6-1ubuntu6.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-dev-tools", ver:"3.3.6-1ubuntu6.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-linguist", ver:"3.3.6-1ubuntu6.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-qtconfig", ver:"3.3.6-1ubuntu6.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-i18n", ver:"3.3.6-1ubuntu6.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-doc", ver:"3.3.6-1ubuntu6.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-examples", ver:"3.3.6-1ubuntu6.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"libqt3-compat-headers", ver:"3.3.6-3ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-headers", ver:"3.3.6-3ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-dev", ver:"3.3.6-3ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-mysql", ver:"3.3.6-3ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-odbc", ver:"3.3.6-3ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-psql", ver:"3.3.6-3ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-sqlite", ver:"3.3.6-3ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt", ver:"3.3.6-3ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt-x11-free-dbg", ver:"3.3.6-3ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-apps-dev", ver:"3.3.6-3ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-assistant", ver:"3.3.6-3ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-designer", ver:"3.3.6-3ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-dev-tools-compat", ver:"3.3.6-3ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-dev-tools-embedded", ver:"3.3.6-3ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-dev-tools", ver:"3.3.6-3ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-linguist", ver:"3.3.6-3ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-qtconfig", ver:"3.3.6-3ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-i18n", ver:"3.3.6-3ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-doc", ver:"3.3.6-3ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-examples", ver:"3.3.6-3ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}