###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for tcp-wrappers vulnerability USN-507-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840101);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "507-1");
  script_cve_id("");
  script_name(english: "Ubuntu Update for tcp-wrappers vulnerability USN-507-1");
  desc["english"] = "

  Vulnerability Insight:

  It was discovered that the TCP wrapper library was incorrectly allowing
  connections to services that did not specify server-side connection
  details.  Remote attackers could connect to services that had been
  configured to block such connections.  This only affected Ubuntu Feisty.

  Affected Software/OS:
  tcp-wrappers vulnerability on Ubuntu 7.04

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-August/000583.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of tcp-wrappers vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libwrap0-dev", ver:"7.6.dbs-11ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libwrap0", ver:"7.6.dbs-11ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tcpd", ver:"7.6.dbs-11ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}