###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for krb5, librpcsecgss vulnerability USN-511-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840163);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "511-2");
  script_cve_id("CVE-2007-4743");
  script_name(english: "Ubuntu Update for krb5, librpcsecgss vulnerability USN-511-2");
  desc["english"] = "

  Vulnerability Insight:

  USN-511-1 fixed vulnerabilities in krb5 and librpcsecgss.  The fixes were
  incomplete, and only reduced the scope of the vulnerability, without fully
  solving it.  This update fixes the problem.
  
  Original advisory details:
  
  It was discovered that the libraries handling RPCSEC_GSS did not correctly
  validate the size of certain packet structures. An unauthenticated remote
  user could send a specially crafted request and execute arbitrary code
  with root privileges.

  Affected Software/OS:
  krb5, librpcsecgss vulnerability on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-September/000588.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of krb5, librpcsecgss vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libkadm55", ver:"1.4.4-5ubuntu3.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb5-dbg", ver:"1.4.4-5ubuntu3.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.4.4-5ubuntu3.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb53", ver:"1.4.4-5ubuntu3.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"librpcsecgss-dev", ver:"0.14-2ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"librpcsecgss3", ver:"0.14-2ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.4.4-5ubuntu3.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-clients", ver:"1.4.4-5ubuntu3.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.4.4-5ubuntu3.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.4.4-5ubuntu3.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.4.4-5ubuntu3.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.4.4-5ubuntu3.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-user", ver:"1.4.4-5ubuntu3.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-doc", ver:"1.4.4-5ubuntu3.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libkadm55", ver:"1.4.3-5ubuntu0.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.4.3-5ubuntu0.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb53", ver:"1.4.3-5ubuntu0.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.4.3-5ubuntu0.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-clients", ver:"1.4.3-5ubuntu0.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.4.3-5ubuntu0.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.4.3-5ubuntu0.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.4.3-5ubuntu0.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.4.3-5ubuntu0.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-user", ver:"1.4.3-5ubuntu0.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"librpcsecgss-dev", ver:"0.7-0ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"librpcsecgss1", ver:"0.7-0ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-doc", ver:"1.4.3-5ubuntu0.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"libkadm55", ver:"1.4.3-9ubuntu1.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb5-dbg", ver:"1.4.3-9ubuntu1.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.4.3-9ubuntu1.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb53", ver:"1.4.3-9ubuntu1.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"librpcsecgss-dev", ver:"0.13-2ubuntu0.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"librpcsecgss2", ver:"0.13-2ubuntu0.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.4.3-9ubuntu1.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-clients", ver:"1.4.3-9ubuntu1.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.4.3-9ubuntu1.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.4.3-9ubuntu1.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.4.3-9ubuntu1.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.4.3-9ubuntu1.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-user", ver:"1.4.3-9ubuntu1.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-doc", ver:"1.4.3-9ubuntu1.5", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}