###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for koffice vulnerabilities USN-542-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840109);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "542-2");
  script_cve_id("CVE-2007-4352", "CVE-2007-5392", "CVE-2007-5393");
  script_name(english: "Ubuntu Update for koffice vulnerabilities USN-542-2");
  desc["english"] = "

  Vulnerability Insight:

  USN-542-1 fixed a vulnerability in poppler. This update provides the
  corresponding updates for KWord, part of KOffice.
  
  Original advisory details:
  
  Secunia Research discovered several vulnerabilities in poppler. If a
  user were tricked into loading a specially crafted PDF file, a remote
  attacker could cause a denial of service or possibly execute arbitrary
  code with the user's privileges in applications linked against poppler.

  Affected Software/OS:
  koffice vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-November/000623.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of koffice vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"karbon", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kchart", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kexi", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kformula", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kivio", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-dbg", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-dev", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-libs", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koshell", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kplato", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kpresenter", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krita", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kspread", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kthesaurus", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kugar", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kword", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kivio-data", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-data", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-doc-html", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-doc", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kpresenter-data", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krita-data", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kword-data", ver:"1.6.2-0ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"karbon", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kchart", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kexi", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kformula", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kivio", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-dbg", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-dev", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-libs", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koshell", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kpresenter", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krita", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kspread", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kthesaurus", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kugar", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kword", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kplato", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kivio-data", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-data", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-doc-html", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-doc", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kpresenter-data", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krita-data", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kword-data", ver:"1.5.0-0ubuntu9.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"karbon", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kchart", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kexi", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kformula", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kivio", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-dbg", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-dev", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-libs", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koshell", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kpresenter", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krita", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kspread", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kthesaurus", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kugar", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kword", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kplato", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kivio-data", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-data", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-doc-html", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-doc", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kpresenter-data", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krita-data", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kword-data", ver:"1.5.2-0ubuntu2.3", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"karbon", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kchart", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kexi", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kformula", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kivio", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-dbg", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-dev", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-libs", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koshell", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kplato", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kpresenter", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krita", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kspread", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kthesaurus", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kugar", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kword", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kivio-data", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-data", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-doc-html", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice-doc", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"koffice", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kpresenter-data", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krita-data", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kword-data", ver:"1.6.3-0ubuntu5.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}