###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for postgresql vulnerabilities USN-568-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840326);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "568-1");
  script_cve_id("CVE-2007-3278", "CVE-2007-4769", "CVE-2007-4772", "CVE-2007-6067", "CVE-2007-6600", "CVE-2007-6601");
  script_name(english: "Ubuntu Update for postgresql vulnerabilities USN-568-1");
  desc["english"] = "

  Vulnerability Insight:

  Nico Leidecker discovered that PostgreSQL did not properly
  restrict dblink functions. An authenticated user could exploit
  this flaw to access arbitrary accounts and execute arbitrary
  SQL queries. (CVE-2007-3278, CVE-2007-6601)
  
  It was discovered that the TCL regular expression parser used
  by PostgreSQL did not properly check its input. An attacker
  could send crafted regular expressions to PostgreSQL and cause
  a denial of service via resource exhaustion or database crash.
  (CVE-2007-4769, CVE-2007-4772, CVE-2007-6067)
  
  It was discovered that PostgreSQL executed VACUUM and ANALYZE
  operations within index functions with superuser privileges and
  also allowed SET ROLE and SET SESSION AUTHORIZATION within index
  functions. A remote authenticated user could exploit these flaws
  to gain privileges. (CVE-2007-6600)

  Affected Software/OS:
  postgresql vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-January/000654.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of postgresql vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libecpg-compat2", ver:"8.2.6-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.2.6-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg5", ver:"8.2.6-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpgtypes2", ver:"8.2.6-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq-dev", ver:"8.2.6-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq5", ver:"8.2.6-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.2_8.2.6-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.2_8.2.6-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.2_8.2.6-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plperl", ver:"8.2_8.2.6-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plpython", ver:"8.2_8.2.6-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-pltcl", ver:"8.2_8.2.6-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-server-dev", ver:"8.2_8.2.6-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.2_8.2.6-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libecpg-compat2", ver:"8.1.11-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.1.11-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg5", ver:"8.1.11-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpgtypes2", ver:"8.1.11-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq-dev", ver:"8.1.11-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq4", ver:"8.1.11-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.1_8.1.11-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.1_8.1.11-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.1_8.1.11-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plperl", ver:"8.1_8.1.11-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plpython", ver:"8.1_8.1.11-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-pltcl", ver:"8.1_8.1.11-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-server-dev", ver:"8.1_8.1.11-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.1_8.1.11-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"libecpg-compat2", ver:"8.1.11-0ubuntu0.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.1.11-0ubuntu0.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg5", ver:"8.1.11-0ubuntu0.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpgtypes2", ver:"8.1.11-0ubuntu0.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq-dev", ver:"8.1.11-0ubuntu0.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq4", ver:"8.1.11-0ubuntu0.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.1_8.1.11-0ubuntu0.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.1_8.1.11-0ubuntu0.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.1_8.1.11-0ubuntu0.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plperl", ver:"8.1_8.1.11-0ubuntu0.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plpython", ver:"8.1_8.1.11-0ubuntu0.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-pltcl", ver:"8.1_8.1.11-0ubuntu0.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-server-dev", ver:"8.1_8.1.11-0ubuntu0.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.1_8.1.11-0ubuntu0.6.10.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"libecpg-compat2", ver:"8.2.6-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.2.6-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg5", ver:"8.2.6-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpgtypes2", ver:"8.2.6-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq-dev", ver:"8.2.6-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq5", ver:"8.2.6-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.2_8.2.6-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.2_8.2.6-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.2_8.2.6-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plperl", ver:"8.2_8.2.6-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plpython", ver:"8.2_8.2.6-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-pltcl", ver:"8.2_8.2.6-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-server-dev", ver:"8.2_8.2.6-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.2.6-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.2.6-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.2_8.2.6-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.2.6-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.2.6-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}