###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for kdelibs vulnerability USN-608-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840303);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "608-1");
  script_cve_id("CVE-2008-1671");
  script_name(english: "Ubuntu Update for kdelibs vulnerability USN-608-1");
  desc["english"] = "

  Vulnerability Insight:

  It was discovered that start_kdeinit in KDE 3 did not properly sanitize
  its input. A local attacker could exploit this to send signals to other
  processes and cause a denial of service or possibly execute arbitrary
  code. (CVE-2008-1671)

  Affected Software/OS:
  kdelibs vulnerability on Ubuntu 7.04 ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-May/000698.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kdelibs vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"kdelibs-dbg", ver:"3.5.6-0ubuntu14.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4-dev", ver:"3.5.6-0ubuntu14.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4c2a", ver:"3.5.6-0ubuntu14.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs-data", ver:"3.5.6-0ubuntu14.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4-doc", ver:"3.5.6-0ubuntu14.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs", ver:"3.5.6-0ubuntu14.3", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"kdelibs-dbg", ver:"3.5.9-0ubuntu7.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4-dev", ver:"3.5.9-0ubuntu7.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4c2a", ver:"3.5.9-0ubuntu7.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs-data", ver:"3.5.9-0ubuntu7.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4-doc", ver:"3.5.9-0ubuntu7.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs", ver:"3.5.9-0ubuntu7.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"kdelibs-dbg", ver:"3.5.8-0ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4-dev", ver:"3.5.8-0ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4c2a", ver:"3.5.8-0ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs-data", ver:"3.5.8-0ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4-doc", ver:"3.5.8-0ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs", ver:"3.5.8-0ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}