###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_vmware_tools_local_prv_esc_vuln_lin.nasl 0279 2008-09-26 14:47:14Z sep $
#
# VMware Tools Local Privilege Escalation Vulnerability (Linux)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800005);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2007-5671");
  script_xref(name:"CB-A", value:"08-0093");
  script_name(english:"VMware Tools Local Privilege Escalation Vulnerability (Linux)");
  desc["english"] = "

  Overview : The host is installed with VMWare product(s) that are vulnerable
  to local privilege escalation vulnerability.

  Vulnerability Insight:
  An input validation error is present in the Windows-based VMware HGFS.sys
  driver. Exploitation of this flaw might result in arbitrary code execution
  on the guest system by an unprivileged guest user. The HGFS.sys driver is
  present in the guest operating system if the VMware Tools package is loaded
  on Windows based Guest OS.

  Impact:
  Successful exploitation could result in guest OS users to modify arbitrary
  memory locations in guest kernel memory and gain privileges.

  Issue still exists even if the host has HGFS disabled and has no shared
  folders.

  Impact Level : System

  Affected Software/OS :
  VMware Player 1.x - before 1.0.6 build 80404 on Linux
  VMware Server 1.x - before 1.0.5 build 80187 on Linux
  VMware Workstation 5.x - before 5.5.6 build 80404 on Linux

  Fix : Upgrade VMware Product(s) to below version,
  VMware Player 1.0.6 build 80404 or later
  www.vmware.com/download/player/

  VMware Server 1.0.5 build 80187 or later
  www.vmware.com/download/server/

  VMware Workstation 5.5.6 build 80404 or later
  www.vmware.com/download/ws/

  References : http://secunia.com/advisories/30556
  http://www.vmware.com/security/advisories/VMSA-2008-0009.html

  CVSS Score :
    CVSS Base Score     : 4.1 (AV:L/AC:M/Au:SI/C:P/I:P/A:P)
    CVSS Temporal Score : 3.0
  Risk factor : Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of VMware Products");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Misc.");
  script_dependencies("gb_vmware_prdts_detect_lin.nasl");
  exit(0);
}


if(!get_kb_item("VMware/Linux/Installed")){
  exit(0);
}

# VMware Player
playerVer = get_kb_item("VMware/Player/Linux/Ver");
if(playerVer)
{
  if(ereg(pattern:"^1\.0(\.[0-5])?($|[^.0-9])", string:playerVer)){
    security_warning(0);
  }
  exit(0);
}

# VMware Server
serverVer = get_kb_item("VMware/Server/Linux/Ver");
if(serverVer)
{
  if(ereg(pattern:"^1\.0(\.[0-4])?($|[^.0-9])", string:serverVer)){
    security_warning(0);
  }
  exit(0);
}

# VMware Workstation
wrkstnVer = get_kb_item("VMware/Workstation/Linux/Ver");
if(wrkstnVer)
{
  if(ereg(pattern:"^5\.([0-4](\..*)?|5(\.[0-5])?)($|[^.0-9])", string:wrkstnVer)){
    security_warning(0);
  }
}
