###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_wireshark_mult_vuln_apr09_lin.nasl 1705 2009-04-16 17:09:24Z apr $
#
# Wireshark Multiple Unspecified Vulnerability - Apr09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800397);
  script_version("$Revision: 1.1 $");
  script_cve_id("CVE-2009-1210", "CVE-2009-1266", "CVE-2009-1267", "CVE-2009-1268",
                "CVE-2009-1269");
  script_bugtraq_id(34291, 34457);
  script_name(english:"Wireshark Multiple Unspecified Vulnerability - Apr09 (Linux)");
  desc["english"] = "

  Overview: This host is installed with Wireshark and is prone to multiple
  unspecified vulnerability.

  Vulnerability Insight:
  - Error exists while processing PN-DCP packet with format string specifiers
    in PROFINET/DCP (PN-DCP) dissector.
  - Error in unknown impact and attack vectors.
  - Error in Lightweight Directory Access Protocol (LDAP) dissector when
    processing unknown attack vectors.
  - Error in Check Point High-Availability Protocol (CPHAP) when processing
    crafted FWHA_MY_STATE packet.
  - An error exists while processing malformed Tektronix .rf5 file.

  Impact:
  Successful exploitation could result in denial of serivce condition.

  Impact Level: Application

  Affected Software/OS:
  Wireshark version 0.9.6 to 1.0.6 on Linux

  Fix: Upgrade to Wireshark 1.0.7
  http://www.wireshark.org/download.html

  References:
  http://milw0rm.com/exploits/8308
  http://secunia.com/advisories/34778
  http://secunia.com/advisories/34542
  http://securitytracker.com/alerts/2009/Apr/1022027.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Wireshark");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Denial of Service");
  script_dependencies("gb_wireshark_detect_lin.nasl");
  script_require_keys("Wireshark/Linux/Ver");
  exit(0);
}


include("version_func.inc");

sharkVer = get_kb_item("Wireshark/Linux/Ver");
if(!sharkVer){
  exit(0);
}

# Grep for Wireshark version prior to 1.0.7
if(version_is_less(version:sharkVer, test_version:"1.0.7")){
  security_hole(0);
}
