###############################################################################
# OpenVAS Vulnerability Test
# $Id:gb_xm_easyftp_dos_vuln.nasl 721 2008-12-23 17:05:29Z dec $
#
# XM Easy Personal FTP Server Denial of Service Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800211);
  script_version("$Revision: 1.0 $");
  script_bugtraq_id(31739);
  script_cve_id("CVE-2008-5626");
  script_name(english:"XM Easy Personal FTP Server Denial of Service Vulnerability");
  desc["english"] = "

  Overview: This host is running XM Easy FTP Personal FTP Server and is prone
  to Denial of Service Vulnerability.

  Vulnerability Insight:
  This flaw is due to a crafted argument to the NLST command.

  Impact:
  Successful exploitation will let the authenticated user execute arbitrary
  codes in the context of the application and can crash the application.

  Affected Software/OS:
  Dxmsoft, XM Easy Personal FTP Server version 5.6.0 and prior

  Fix: No solution/patch is available as on 23rd December, 2008. Information
  regarding this issue will updated once the solution details are available.
  For updates refer, http://www.dxm2008.com

  References:
  http://www.milw0rm.com/exploits/6741
  http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2008-5626

  CVSS Score:
    CVSS Base Score     : 4.0 (AV:N/AC:L/Au:SI/C:N/I:N/A:P)
    CVSS Temporal Score : 3.6
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of XM Easy Personal FTP Server");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Denial of Service");
  script_dependencies("find_service.nes");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");
include("version_func.inc");

port = get_kb_item("Services/ftp");
if(!port){
  port = 21;
}

if(!get_port_state(port)){
  exit(0);
}

banner = get_ftp_banner(port:port);
if("DXM's FTP Server" >!< banner){
  exit(0);
}

dxmVer = eregmatch(pattern:"DXM's FTP Server ([0-9.]+)", string:banner);
if(dxmVer[1] != NULL)
{
  # Grep for version 5.6.0 and prior
  if(version_is_less_equal(version:dxmVer[1], test_version:"5.6.0")){
    security_warning(port);
  }
}
