# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54509);
 script_bugtraq_id(9153);
 script_cve_id("CVE-2003-0962");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200312-03 (rsync)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200312-03.

rsync contains a heap overflow vulnerability that can be used to execute
arbitrary code.

Solution:
To address this vulnerability, all Gentoo users should read GLSA-200312-02
and ensure that all systems are upgraded to a version of the Linux kernel
without the do_brk() vulnerability, and upgrade to version 2.5.7 of rsync:

    # emerge sync
    # emerge -pv '>=net-misc/rsync-2.5.7'
    # emerge '>=net-misc/rsync-2.5.7'
    # emerge clean

Review your /etc/rsync/rsyncd.conf configuration file; ensure that the use
chroot='no' command is commented out or removed, or change use chroot='no'
to use chroot='yes'.  Then, if necessary, restart rsyncd:

    # /etc/init.d/rsyncd restart

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200312-03
http://rsync.samba.org/#security_dec03
http://security.gentoo.org/glsa/glsa-200312-02.xml
http://security.gentoo.org/glsa/glsa-200312-01.xml

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200312-03 (rsync)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"net-misc/rsync", unaffected: make_list("ge 2.5.7"), vulnerable: make_list("lt 2.5.6*"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
