# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54529);
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200403-04 (Apache)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200403-04.

A memory leak in mod_ssl allows a remote denial of service attack against
an SSL-enabled server via plain HTTP requests. Another flaw was found when
arbitrary client-supplied strings can be written to the error log,
allowing the exploit of certain terminal emulators. A third flaw exists
with the mod_disk_cache module.

Solution:
Users are urged to upgrade to Apache 2.0.49:

    # emerge sync
    # emerge -pv '>=net-www/apache-2.0.49'
    # emerge '>=net-www/apache-2.0.49'

    # ** IMPORTANT **

    # If you are migrating from Apache 2.0.48-r1 or earlier versions,
    # it is important that the following directories are removed.

    # The following commands should cause no data loss since these
    # are symbolic links.

    # rm /etc/apache2/lib /etc/apache2/logs /etc/apache2/modules
    # rm /etc/apache2/extramodules

    # ** ** ** ** **

    # ** ALSO NOTE **

    # Users who use mod_disk_cache should edit their Apache
    # configuration and disable mod_disk_cache.
    

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200403-04
http://bugs.gentoo.org/show_bug.cgi?id=45206
http://www.securityfocus.com/bid/9933/info/
http://www.apache.org/dist/httpd/Announcement2.html

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200403-04 (Apache)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"net-www/apache", unaffected: make_list("eq 1.3*", "ge 2.0.49"), vulnerable: make_list("le 2.0.48"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
