# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54559);
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200404-20 (xine)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200404-20.

Several vulnerabilities have been found in xine-ui and xine-lib,
potentially allowing an attacker to overwrite files with the rights of the
user.

Solution:
All users of xine-ui or another xine-based player should upgrade to the
latest stable versions:

    # emerge sync

    # emerge -pv '>=media-video/xine-ui-0.9.23-r2'
    # emerge '>=media-video/xine-ui-0.9.23-r2'

    # emerge -pv '>=media-libs/xine-lib-1_rc3-r3'
    # emerge '>=media-libs/xine-lib-1_rc3-r3'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200404-20
http://bugs.gentoo.org/show_bug.cgi?id=45448
http://bugs.gentoo.org/show_bug.cgi?id=48107
http://bugs.gentoo.org/show_bug.cgi?id=48108
http://xinehq.de/index.php/security
http://nettwerked.mg2.org/advisories/xinebug

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200404-20 (xine)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"media-video/xine-ui", unaffected: make_list("ge 0.9.23-r2"), vulnerable: make_list("le 0.9.23-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"media-libs/xine-lib", unaffected: make_list("ge 1_rc3-r3"), vulnerable: make_list("le 1_rc3-r2"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
