# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54564);
 script_bugtraq_id(10136);
 script_cve_id("CVE-2004-0179");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200405-04 (openoffice)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200405-04.

Several format string vulnerabilities are present in the Neon library
included in OpenOffice.org, allowing remote execution of arbitrary code
when connected to an untrusted WebDAV server.

Solution:
There is no Ximian OpenOffice.org binary version including the fix yet. All
users of the openoffice-ximian-bin package making use of the WebDAV
openoffice-ximian source-based package should:

# emerge sync
# emerge -pv '>=app-office/openoffice-VERSION'
# emerge '>=app-office/openoffice-VERSION'

openoffice users on x86 should use version: 1.1.1-r1
openoffice users on sparc should use version: 1.1.0-r3
openoffice users on ppc should use version: 1.0.3-r1
openoffice-ximian users should use version: 1.1.51-r1
openoffice-bin users should use version: 1.1.2

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200405-04
http://bugs.gentoo.org/show_bug.cgi?id=47926
http://www.gentoo.org/security/en/glsa/glsa-200405-01.xml

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200405-04 (openoffice)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"app-office/openoffice", unaffected: make_list("ge 1.1.1-r1"), vulnerable: make_list("le 1.1.1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"app-office/openoffice", unaffected: make_list("ge 1.0.3-r2"), vulnerable: make_list("le 1.0.3-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"app-office/openoffice", unaffected: make_list("ge 1.1.0-r4"), vulnerable: make_list("le 1.1.0-r3"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"app-office/openoffice-ximian", unaffected: make_list("ge 1.1.51-r1"), vulnerable: make_list("le 1.1.51"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"app-office/openoffice-bin", unaffected: make_list("ge 1.1.2"), vulnerable: make_list("lt 1.1.2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"app-office/openoffice-ximian-bin", unaffected: make_list(), vulnerable: make_list("le 1.1.52"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
