# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54695);
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200410-04 (PHP)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200410-04.

Two bugs in PHP may allow the disclosure of portions of memory and allow
remote attackers to upload files to arbitrary locations.

Solution:
All PHP, mod_php and php-cgi users should upgrade to the latest stable
version:

    # emerge sync

    # emerge -pv '>=dev-php/php-4.3.9'
    # emerge '>=dev-php/php-4.3.9'

    # emerge -pv '>=dev-php/mod_php-4.3.9'
    # emerge '>=dev-php/mod_php-4.3.9'

    # emerge -pv '>=dev-php/php-cgi-4.3.9'
    # emerge '>=dev-php/php-cgi-4.3.9'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200410-04
http://bugs.gentoo.org/show_bug.cgi?id=64223
http://secunia.com/advisories/12560/
http://www.securityfocus.com/archive/1/375294
http://www.securityfocus.com/archive/1/375370

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200410-04 (PHP)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"dev-php/php", unaffected: make_list("ge 4.3.9"), vulnerable: make_list("lt 4.3.9"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"dev-php/mod_php", unaffected: make_list("ge 4.3.9"), vulnerable: make_list("lt 4.3.9"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"dev-php/php-cgi", unaffected: make_list("ge 4.3.9"), vulnerable: make_list("lt 4.3.9"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
