# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54909);
 script_bugtraq_id(12770);
 script_cve_id("CVE-2005-0706");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200504-07 (GnomeVFS)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200504-07.

The GnomeVFS and libcdaudio libraries contain a buffer overflow that can be
triggered by a large CDDB response, potentially allowing the execution of
arbitrary code.

Solution:
All GnomeVFS users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose gnome-base/gnome-vfs

All libcdaudio users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose
'>=media-libs/libcdaudio-0.99.10-r1'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200504-07
http://bugs.gentoo.org/show_bug.cgi?id=84936
http://www.gentoo.org/security/en/glsa/glsa-200503-21.xml

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200504-07 (GnomeVFS)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"gnome-base/gnome-vfs", unaffected: make_list("ge 2.8.4-r1", "rge 1.0.5-r4"), vulnerable: make_list("lt 2.8.4-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"media-libs/libcdaudio", unaffected: make_list("ge 0.99.10-r1"), vulnerable: make_list("lt 0.99.10-r1"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
