# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(54987);
 script_cve_id("CVE-2005-1174", "CVE-2005-1175", "CVE-2005-1689");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200507-11 (mit-krb5)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200507-11.

MIT Kerberos 5 is vulnerable to a Denial of Service attack and remote
execution of arbitrary code, possibly leading to the compromise of the
entire Kerberos realm.

Solution:
All MIT Kerberos 5 users should upgrade to the latest available version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=app-crypt/mit-krb5-1.4.1-r1'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200507-11
http://bugs.gentoo.org/show_bug.cgi?id=98799
http://web.mit.edu/kerberos/advisories/MITKRB5-SA-2005-002-kdc.txt
http://web.mit.edu/kerberos/advisories/MITKRB5-SA-2005-003-recvauth.txt

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200507-11 (mit-krb5)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"app-crypt/mit-krb5", unaffected: make_list("ge 1.4.1-r1"), vulnerable: make_list("lt 1.4.1-r1"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
