# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(55649);
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200510-14 (Perl Qt-UnixODBC CMake)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200510-14.

Multiple packages suffer from RUNPATH issues that may allow users in the
'portage' group to escalate privileges.

Solution:
All Perl users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose dev-lang/perl

All Qt-UnixODBC users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=dev-db/qt-unixodbc-3.3.4-r1'

All CMake users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose dev-util/cmake

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200510-14
http://bugs.gentoo.org/show_bug.cgi?id=105719
http://bugs.gentoo.org/show_bug.cgi?id=105721
http://bugs.gentoo.org/show_bug.cgi?id=106678

Risk factor : Low";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200510-14 (Perl Qt-UnixODBC CMake)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"dev-lang/perl", unaffected: make_list("ge 5.8.7-r1", "rge 5.8.6-r6"), vulnerable: make_list("lt 5.8.7-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"dev-db/qt-unixodbc", unaffected: make_list("ge 3.3.4-r1"), vulnerable: make_list("lt 3.3.4-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"dev-util/cmake", unaffected: make_list("ge 2.2.0-r1", "rge 2.0.6-r1"), vulnerable: make_list("lt 2.2.0-r1"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
