# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(56229);
 script_cve_id("CVE-2005-3627", "CVE-2005-3626", "CVE-2005-3625", "CVE-2005-3624");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200601-17 (xpdf poppler gpdf libextractor pdftohtml)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200601-17.

Xpdf, Poppler, GPdf, libextractor and pdftohtml are vulnerable to integer
overflows that may be exploited to execute arbitrary code.

Solution:
All Xpdf users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=app-text/xpdf-3.01-r5'

All Poppler users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=app-text/poppler-0.4.3-r4'

All GPdf users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=app-text/gpdf-2.10.0-r3'

All libextractor users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=media-libs/libextractor-0.5.9'

All pdftohtml users should migrate to the latest stable version of
Poppler.

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200601-17
http://bugs.gentoo.org/show_bug.cgi?id=117481
http://bugs.gentoo.org/show_bug.cgi?id=117494
http://bugs.gentoo.org/show_bug.cgi?id=117495
http://bugs.gentoo.org/show_bug.cgi?id=115789
http://bugs.gentoo.org/show_bug.cgi?id=118665

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200601-17 (xpdf poppler gpdf libextractor pdftohtml)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"app-text/xpdf", unaffected: make_list("ge 3.01-r5"), vulnerable: make_list("lt 3.01-r5"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"app-text/poppler", unaffected: make_list("ge 0.4.3-r4"), vulnerable: make_list("lt 0.4.3-r4"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"app-text/gpdf", unaffected: make_list("ge 2.10.0-r3"), vulnerable: make_list("lt 2.10.0-r3"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"media-libs/libextractor", unaffected: make_list("ge 0.5.9"), vulnerable: make_list("lt 0.5.9"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"app-text/pdftohtml", unaffected: make_list(), vulnerable: make_list("lt 0.36-r4"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
