# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(58297);
 script_cve_id("CVE-2007-1001", "CVE-2007-1285", "CVE-2007-1286", "CVE-2007-1484", "CVE-2007-1521", "CVE-2007-1583", "CVE-2007-1700", "CVE-2007-1701", "CVE-2007-1711", "CVE-2007-1717", "CVE-2007-1718", "CVE-2007-1864", "CVE-2007-1900", "CVE-2007-2509", "CVE-2007-2510", "CVE-2007-2511");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200705-19 (php)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200705-19.

PHP contains several vulnerabilities including buffer and integer overflows
which could under certain conditions lead to the remote execution of
arbitrary code.

Solution:
All PHP 5 users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=dev-lang/php-5.2.2'

All PHP 4 users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=dev-lang/php-4.4.7'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200705-19
http://bugs.gentoo.org/show_bug.cgi?id=169372

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200705-19 (php)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"dev-lang/php", unaffected: make_list("rge 4.4.7", "ge 5.2.2"), vulnerable: make_list("lt 5.2.2"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
