# OpenVAS Vulnerability Test
# $
# Description: Auto generated from Gentoo's XML based advisory
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(59242);
 script_cve_id("CVE-2007-4352", "CVE-2007-5392", "CVE-2007-5393");
 script_version ("$");
 name["english"] = "Gentoo Security Advisory GLSA 200711-22 (poppler koffice kword kdegraphics kpdf)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory GLSA 200711-22.

Poppler and various KDE components are vulnerable to multiple memory
management issues possibly resulting in the execution of arbitrary code.

Solution:
All Poppler users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=app-text/poppler-0.6.1-r1'

All KPDF users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=kde-base/kpdf-3.5.7-r3'

All KDE Graphics Libraries users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=kde-base/kdegraphics-3.5.7-r3'

All KWord users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=app-office/kword-1.6.3-r2'

All KOffice users should upgrade to the latest version:

    # emerge --sync
    # emerge --ask --oneshot --verbose '>=app-office/koffice-1.6.3-r2'

http://www.securityspace.com/smysecure/catid.html?in=GLSA%20200711-22
http://bugs.gentoo.org/show_bug.cgi?id=196735
http://bugs.gentoo.org/show_bug.cgi?id=198409

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Gentoo Security Advisory GLSA 200711-22 (poppler koffice kword kdegraphics kpdf)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Gentoo Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/gentoo");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-gentoo.inc");
vuln = 0;
if(ispkgvuln(pkg:"app-text/poppler", unaffected: make_list("ge 0.6.1-r1"), vulnerable: make_list("lt 0.6.1-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"kde-base/kpdf", unaffected: make_list("rge 3.5.7-r3", "ge 3.5.8-r1"), vulnerable: make_list("lt 3.5.8-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"kde-base/kdegraphics", unaffected: make_list("rge 3.5.7-r3", "ge 3.5.8-r1"), vulnerable: make_list("lt 3.5.8-r1"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"app-office/kword", unaffected: make_list("ge 1.6.3-r2"), vulnerable: make_list("lt 1.6.3-r2"))) {
    vuln=1;
}
if(ispkgvuln(pkg:"app-office/koffice", unaffected: make_list("ge 1.6.3-r2"), vulnerable: make_list("lt 1.6.3-r2"))) {
    vuln=1;
}

if(vuln) {
    security_hole(0);
}
