###############################################################################
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
# (C) Tenable Network Security
#
# Updated: 03/12/2009 Antu Sanadi <santu@secpod.com>
#
# Ref: Secunia <http://www.secunia.com>
# This script is released under the GNU GPLv2
###############################################################################

if(description)
{
  script_id(14247);
  script_cve_id("CVE-2004-2083");
  script_bugtraq_id(9640);
  script_version("$Revision: 2750 $");
  script_name(english:"Opera web browser file download extension spoofing");
  desc["english"] = "
  Overview: The remote host is using Opera - an alternative web browser.
  This version contains a flaw that may allow a malicious user
  to trick a user into running arbitrary code.
  The issue is triggered when an malicious web site provides a file for download,
  but crafts the filename in such a way that the file is executed, rather than saved.
  It is possible that the flaw may allow arbitrary code execution resulting in a
  loss of confidentiality, integrity, and/or availability.

  Solution : Install Opera 7.50 or newer.

  Risk factor : High";

  script_description(english:desc["english"]);
  script_summary(english:"Determines the version of Opera.exe");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
  script_family(english:"Windows");
  script_dependencies("secpod_opera_detection_win_900036.nasl");
  script_require_keys("Opera/Win/Version");
  exit(0);
}


include("version_func.inc");

OperaVer = get_kb_item("Opera/Win/Version");
if(!OperaVer){
  exit(0);
}

if(version_is_less_equal(version:OperaVer, test_version:"7.49")){
  security_hole(0);
}
