###############################################################################
# OpenVAS Vulnerability Test
# $Id: phorum_34551.nasl 3194 2009-04-24 18:04:08Z mime $
#
# Phorum Multiple Cross Site Scripting Vulnerabilities
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100164);
 script_bugtraq_id(34551);
 script_version ("1.0");

 script_name(english:"Phorum Multiple Cross Site Scripting Vulnerabilities");
 desc["english"] = "

 Overview:
  According to its version number, the remote version of Phorum is
  prone to multiple cross-site scripting vulnerabilities because the
  application fails to sufficiently sanitize user-supplied input.

  An attacker can exploit these issues to steal cookie-based
  authentication credentials and launch other attacks.

  Phorum 5.2.10 and 5.2-dev are vulnerable; other versions may also be
  affected.

 See also:
  http://www.securityfocus.com/bid/34551

 Risk factor : Medium";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if Phorum is vulnerable to multiple XSS");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Web application abuses");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("phorum_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

if(!version = get_kb_item(string("www/", port, "/phorum")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_equal(version: vers, test_version: "5.2.10") ||
     ereg(pattern:"^5\.2-dev$", string: vers))
  {
      security_hole(port:port);
      exit(0);
  }  

}   

exit(0);
