##############################################################################
#
#  Anzio Web Print Object ActiveX Control Remote BOF Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/01
#
#  Revision: 1.1
#
#  Log : ssharath
#  Issue #0152
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900115);
 script_bugtraq_id(30545);
 script_cve_id("CVE-2008-3480");
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Misc.");
 script_name(english:"Anzio Web Print Object ActiveX Control Remote BOF Vulnerability");
 script_summary(english:"Check for vulnerable version and prior of Anzio");
 desc["english"] = "
 Overview : The host is running Anzio, which is prone to a heap-based buffer
 overflow vulnerability.

 Vulnerability Insight :

        The flaw is due to an error while handling an overly long value in 
        mainurl parameter.

        Impact: An attacker can execute arbitrary code causing a stack based 
        buffer overflow by tricking a user to visit malicious web page. 

 Impact Level : Application

 Affected Software/OS :
        Anzio Web Print Object versions prior to 3.2.30 on Windows (All)

 Fix : Upgrade to Anzio Web Print Object version 3.2.30
 http://www.anzio.com/download-wepo.htm

 References :
 http://secunia.com/advisories/31554/
 http://en.securitylab.ru/poc/extra/358295.php
 http://www.coresecurity.com/content/anzio-web-print-object-buffer-overflow

 CVSS Score :
        CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
        CVSS Temporal Score : 5.3
 Risk factor : High"; 

 script_description(english:desc["english"]);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}


 include("smb_nt.inc");
 include("secpod_smb_func.inc");

 if (!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 anzioPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion"
				+ "\App Paths\pwui.exe", item:"Path");
 if(!anzioPath){
        exit(0);
 }

 share = ereg_replace(pattern:"([A-Z]):.*",replace:"\1$",string:anzioPath);
 file = ereg_replace(pattern:"[A-Z]:(.*)",replace:"\1",string:anzioPath + "\pwui.exe");

 name = kb_smb_name();
 domain = kb_smb_domain();
 login = kb_smb_login();
 pass = kb_smb_password();
 port = kb_smb_transport();

 soc = open_sock_tcp(port);
 if(!soc){
        exit(0);
 }
 r = smb_session_request(soc:soc, remote:name);
 if(!r){
        close(soc);
        exit(0);
 }

 prot = smb_neg_prot(soc:soc);
 if(!prot){
        close(soc);
        exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass,
                       domain:domain, prot:prot);
 if(!r){
        close(soc);
        exit(0);
 }

 uid = session_extract_uid(reply:r);
 r = smb_tconx(soc:soc, name:name, uid:uid, share:share);

 tid = tconx_extract_tid(reply:r);
 if(!tid){
        close(soc);
        exit(0);
 }

 fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
 if(!fid){
        close(soc);
        exit(0);
 }

 anzioVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, verstr:"File Version");
 close(soc);

 if(!anzioVer){
        exit(0);
 }

 if(egrep(pattern:"^([0-2]\..*|3\.([01](\..*)?|2(\.[0-2]?[0-9])?\.0))$",
	  string:anzioVer)){
 	security_hole(0);
 }
