###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_audacity_bof_vuln_lin.nasl 1000 2009-02-16 10:50:24Z feb $
#
# Audacity Buffer Overflow Vulnerability (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900307);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0490");
  script_bugtraq_id(33090);
  script_name(english:"Audacity Buffer Overflow Vulnerability (Linux)");
  desc["english"] = "

  Overview: This host has Audacity installed and is prone to Buffer Overflow
  vulnerability.

  Vulnerability Insight:
  Error in the String_parse::get_nonspace_quoted function in
  lib-src/allegro/strparse.cpp file that fails to validate user input data.

  Impact:
  Attacker may leverage this issue by executing arbitrary script code on
  the affected application, and can cause denial of service.

  Impact Level: Application

  Affected Software/OS:
  Audacity version prior to 1.3.6 on Linux.

  Fix: Upgrade to version 1.3.6 or latest
  http://audacity.sourceforge.net/

  References:
  http://secunia.com/advisories/33356
  http://www.milw0rm.com/exploits/7634

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of Audacity");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Buffer overflow");
  script_dependencies("secpod_audacity_detect_lin.nasl");
  script_require_keys("Audacity/Linux/Ver");
  exit(0);
}


include("version_func.inc");

audacityVer = get_kb_item("Audacity/Linux/Ver");
if(!audacityVer){
  exit(0);
}

# Check for Audacity version < 1.3.6
if(version_is_less(version:audacityVer, test_version:"1.3.6")){
  security_hole(0);
}
