##############################################################################
#
#  CA kmxfw.sys Code Execution and DoS Vulnerabilities.
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/18
#
#  Revision: 1.1
#
#  Log: veerendragg
#  Issue #0122
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900202);
 script_bugtraq_id(30651);
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Denial of Service");
 script_name(english:"CA kmxfw.sys Code Execution and DoS Vulnerabilities");
 script_summary(english:"Check for Engine version");
 desc["english"] = "
 Overview : This host is running CA Product(s), which is prone to Local Code
 Execution and Denial of Service Vulnerabilities.

 Vulnerability Insight :

        Multiple flaw are due to insufficient verification/validation of IOCTL
        requests by the kmxfw.sys driver.

        Impact : A remote/local user can cause denial of service conditions or
        execute arbitrary code by sending a specially crafted IOCTL requests.

 Impact Level : Application

 Affected Software/OS :
       CA Internet Security Suite 2007 (v3.2) with CA Personal Firewall 
          2007 (v9.1) Engine version 1.2.260 and below
       CA Internet Security Suite 2008 (v4.0) with CA Personal Firewall 
          2008 (v10.0) Engine version 1.2.260 and below
       CA Personal Firewall 2007 (v9.1) with Engine version 1.2.260 and below
       CA Personal Firewall 2008 (v10.0) with Engine version 1.2.260 and below
       CA Host-Based Intrusion Prevention System r8


 Fix : Ensure the latest engine is installed by using the built-in update 
 mechanism and for Host-Based Intrusion Prevention System,
 https://support.ca.com/irj/portal/anonymous/SolutionResults?aparNo=RO00535&actionID=4
 ftp://ftp.ca.com/CAproducts/unicenter/CAHIPS/nt/0703/RO00535/RO00535.CAZ

 References : http://www.ca.com/us/securityadvisor/vulninfo/vuln.aspx?id=36560
	      http://www.ca.com/us/securityadvisor/vulninfo/vuln.aspx?id=36559
	      http://www.securityfocus.com/archive/1/archive/1/495397/100/0/threaded
      	      http://securitytracker.com/alerts/2008/Aug/1020662.html
      	      http://securitytracker.com/alerts/2008/Aug/1020663.html
	      http://www.trapkit.de/advisories/TKADV2008-006.txt
	      http://seclists.org/fulldisclosure/2008/Aug/0256.html

 CVSS Score :
        CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
        CVSS Temporal Score : 6.1
 Risk factor : High";

 script_description(english:desc["english"]);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}


 include("smb_nt.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 caEngVer = registry_get_sz(key:"SOFTWARE\CA\HIPSEngine", item:"Version");
 if(!caEngVer){
	exit(0);
 }

 # Grep for EngineVersion < 1.2.276 
 if(egrep(pattern:"^(0\..*|1\.[01](\..*)?|1\.2(\.([01]?[0-9]?[0-9]|" +
		  "2[0-6][0-9]|27[0-5]))?)$",
                 string:caEngVer)){
       	security_hole(0);
 }
