###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_clamav_dos_vuln_lin.nasl 1931 2009-04-28 11:09:31Z apr $
#
# ClamAV Denial of Service Vulnerability (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900545);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2009-1371", "CVE-2009-1372");
  script_bugtraq_id(34446);
  script_name(english:"ClamAV Denial of Service Vulnerability (Linux)");
  desc["english"] = "

  Overview: The host is installed with ClamAV and is prone to Denial of Service
  Vulnerability.

  Vulnerability Insight:
  - Error in CLI_ISCONTAINED macro in libclamav/others.h while processing
    malformed files packed with UPack.
  - Buffer overflow error in cli_url_canon() function in libclamav/phishcheck.c
    while handling specially crafted URLs.

  Impact:
  Attackers can exploit this issue by executing arbitrary code via a crafted
  URL in the context of affected application, and can cause denial of service.

  Impact Level: Application

  Affected Software/OS:
  ClamAV before 0.95.1 on Linux.

  Fix: Upgrade to ClamAV 0.95.1
  http://www.clamav.net/download

  References:
  http://secunia.com/advisories/34612/
  http://www.vupen.com/english/advisories/2009/0985

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ClamAV");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Denial of Service");
  script_dependencies("gb_clamav_detect_lin.nasl");
  script_require_keys("ClamAV/Lin/Ver");
  exit(0);
}


include("version_func.inc");

avVer = get_kb_item("ClamAV/Lin/Ver");
if(avVer == NULL){
  exit(0);
}

if(version_is_less(version:avVer, test_version:"0.95.1")){
  security_warning(0);
}
