##############################################################################
#
#  HP SMH Unspecified Security Bypass Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/11/14
#
#  Revision: 1.0
#
#  Log: ssharath
#  Issue #0476
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900167);
  script_bugtraq_id(32088);
  script_cve_id("CVE-2008-4413");
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Misc.");
  script_name(english:"HP SMH Unspecified Security Bypass Vulnerability");
  script_summary(english:"Check for vulnerable version of HP SMH");
  desc["english"] = "
  Overview: The host is running System Management Homepage and is prone to
  local security bypass vulnerability.

  The flaw is caused by an unspecified error, which can be exploited by
  local users to perform certain actions with escalated privileges.

  Impact:
  Attackers can leverage this issue to gain local unauthorized access.

  Impact Level: Application

  Affected Software/OS:
  HP SMH version 2.2.6 and prior on HP-UX B.11.11 and B.11.23
  HP SMH version 2.2.6 and 2.2.8 and prior on HP-UX B.11.23 and B.11.31

  Fix: Update to HP SMH version 2.2.9.1 or subsequent
  http://software.hp.com

  *****
  NOTE: Ignore this warning, if OS is other than HP-UX B.11.11 and B.11.23,
        HP-UX B.11.23 and B.11.31.
  *****

  References:
  http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2008-4413
  http://h20000.www2.hp.com/bizsupport/TechSupport/Document.jsp?objectID=c01586921

  CVSS Score:
    CVSS Base Score     : 6.2 (AV:L/AC:L/Au:SI/C:C/I:C/A:N)
    CVSS Temporal Score : 4.6
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_dependencie("http_version.nasl");
  exit(0);
}


include("http_func.inc");

smhPort = 2301;
if(get_port_state(smhPort))
{
  smhReq = http_get(item:"/", port:smhPort);
  smhRes = http_send_recv(port:smhPort, data:smhReq);
  if(egrep(pattern:"CompaqHTTPServer/9\.9 HP System Management Homepage",
     string:smhRes) && egrep(pattern:"^HTTP/.* 302 Found", string:smhRes))
  {
    # Grep the versions < 2.2.9.1
    pattern = "/[01](\..*)|2.([01](\..*)?|2(\.[0-8](\..*)?|\.9\.0)?)($|[^.0-9])";
    if(egrep(pattern:pattern, string:smhRes)){
       security_warning(0);
    }
  }
}
