###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_hplip_sec_bypass_vuln.nasl 852 2009-01-23 13:10:29Z jan $
#
# HP Linux Imaging and Printing System Security Bypass Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900429);
  script_version("$Revision: 1.0 $");
  script_bugtraq_id(33249);
  script_cve_id("CVE-2009-0122");
  script_name(english:"HP Linux Imaging and Printing System Security Bypass Vulnerability");
  desc["english"] = "

  Overview: This host is installed with HP Linux Imaging and Printing System
  and is prone to Security Bypass vulnerability.

  Vulnerability Insight:
  This flaw is due to the 'postinst' script of the hplip package which tries
  to change the permissions of user config files in an insecure manner.

  Impact:
  Successful exploitation will let the attacker gain unauthorized privileges
  and escalate the privileges in a malicious way.

  Affected Software/OS:
  HP Linux Imaging and Printing System version 2.7.7 or 2.8.2

  Fix: Upgrade to Higher version,
  http://security.ubuntu.com/ubuntu/pool/main/h/hplip/

  *****
  NOTE: Please ignore the warning, if patch is applied.
  *****

  References:
  http://secunia.com/advisories/33539
  http://www.ubuntu.com/usn/usn-708-1
  https://bugs.launchpad.net/ubuntu/+source/hplip/+bug/191299

  CVSS Score:
    CVSS Base Score     : 6.9 (AV:L/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 5.7
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of HP-LIP");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Privilege escalation");
  script_dependencies("secpod_hplip_detect_lin.nasl");
  script_require_keys("HP-LIP/Linux/Ver");
  exit(0);
}


hplipVer = get_kb_item("HP-LIP/Linux/Ver");
if(hplipVer != NULL)
{
  # Grep for version 2.7.7 or 2.8.2
  if(hplipVer =~ "2.7.7|2.8.2"){
    security_hole(0);
  }
}
