##############################################################################
#
#  Ichitaro Document Handling Unspecified Code Execution Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/27
#
#  Revision: 1.1
#
#  Log: veerendragg
#  Issue #0147
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900207);
 script_bugtraq_id(30828);
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Misc.");
 script_name(english:"Ichitaro Document Handling Unspecified Code Execution Vulnerability");
 script_summary(english:"Check for the version of Ichitaro");
 desc["english"] = "
 Overview : This host is running Ichitaro, which is prone to Unspecified Remote
 Code Execution Vulnerability.

 Vulnerability Insight :

        The issue is due to error that exists while processing specially 
        crafted docuement form.

        Impact : Successful exploitation will allow execution arbitrary code
        within the context of the vulnerable application. 

 Impact Level : Application

 Affected Software/OS :
        Justsystem Ichitaro 2008 and prior versions on Windows (All).

 Fix : No solution/patch is available as on 28th August, 2008. Information
 regarding this issue will updated once the solution details are available.
 For updates refer, http://www.ichitaro.com

 References :
 http://secunia.com/advisories/31603/
 http://www.justsystems.com/jp/info/pd8002.html

 CVSS Score :
        CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
        CVSS Temporal Score : 6.4
 Risk factor : Medium";

 script_description(english:desc["english"]);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}


 include("smb_nt.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 if(!registry_key_exists(key:"SOFTWARE\Justsystem\ATOK")){
        exit(0);
 }

 name   =  kb_smb_name();
 login  =  kb_smb_login();
 pass   =  kb_smb_password();
 domain =  kb_smb_domain();
 port   =  kb_smb_transport();

 if(!port){
	port = 139;
 }

 if(!get_port_state(port)){
	exit(0);
 }

 soc = open_sock_tcp(port);
 if(!soc){
        exit(0);
 }

 r = smb_session_request(soc:soc, remote:name);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 prot = smb_neg_prot(soc:soc);
 if(!prot)
 {
        close(soc);
        exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass,
                       domain:domain, prot:prot);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 uid = session_extract_uid(reply:r);
 r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");

 tid = tconx_extract_tid(reply:r);
 if(!tid)
 {
        close(soc);
        exit(0);
 }

 r = smbntcreatex(soc:soc, uid:uid, tid:tid, name:"\winreg");
 if(!r)
 {
        close(soc);
        exit(0);
 }

 pipe = smbntcreatex_extract_pipe(reply:r);
 if(!pipe)
 {
        close(soc);
        exit(0);
 }

 r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!handle)
 {
        close(soc);
        exit(0);
 }

 key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
 key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe,
                          key:key, reply:handle);
 if(!key_h)
 {
	close(soc);
 	exit(0);
 }
 
 enumKeys = registry_enum_key(soc:soc, uid:uid, tid:tid,
                              pipe:pipe, reply:key_h);
 foreach entry (enumKeys)
 {
        appName = registry_get_sz(item:"DisplayName", key:key + entry);
        if(appName && "ATOK" >< appName)
        {
                if(egrep(pattern:"ATOK ([01][0-9][0-9][0-9]|200[0-8]|" +
			 	 "(9\.|1[0-3]\.)).*", string:appName)){
                        security_warning(0);
                }
                exit(0);
        }
 }
