###############################################################################
# OpenVAS Vulnerability Test
# $Id:secpod_mikmod_dos_vuln.nasl 879 2009-01-22 15:10:29Z jan $
#
# MikMod Module Player Denial of Service Vulnerability (Linux)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900443);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0179");
  script_bugtraq_id(33235);
  script_name(english:"MikMod Module Player Denial of Service Vulnerability (Linux)");
  desc["english"] = "

  Overview: This host is installed with MikMod Module Player and is prone to
  Denial of Service vulnerability.

  Vulnerability Insight:
  - libmikmod library using a global variable to keep track of the number of
    channels can be exploited to crash an application using the library by
    loading a module with more channels than the currently playing module.
  - Error when processing the header of certain XM files which can be
    exploited to crash an application using the library via a specially
    crafted XM file.

  Impact:
  Successful exploitation will let the attacker crash the application to cause
  denial-of-service condition.

  Impact level: Application

  Affected Software/OS:
  MikMod Module Player version 3.1.11 to 3.2.0 on Linux.

  Fix: Apply Patch,
  http://bugs.debian.org/cgi-bin/bugreport.cgi?msg=5;filename=31.xm-header.patch;att=1;bug=476339

  References:
  http://secunia.com/advisories/33485
  http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=461519

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of MikMod Player");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Denial of Service");
  script_dependencies("secpod_mikmod_detect.nasl");
  script_require_keys("MikMod/Linux/Ver");
  exit(0);
}


include("version_func.inc");

mikmodVer = get_kb_item("MikMod/Linux/Ver");
if(mikmodVer != NULL)
{
  #Grep for MikMod version 3.1.11 to 3.2.0
  if(version_in_range(version:mikmodVer, test_version:"3.1.11",
                                         test_version2:"3.2.0")){
    security_warning(0);
  }
}
