##############################################################################
#
#  Microsoft Excel Remote Code Execution Vulnerability (956416)
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/15
#
#  Revision: 1.1
#
#  Log: schandan
#  Issue #0323
#
#  Make use of version_func_inc - By Chandan S, 11:48:13 2009/04/24
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
  script_id(900048);
  script_bugtraq_id(31702, 31705, 31706);
  script_cve_id("CVE-2008-3471", "CVE-2008-3477", "CVE-2008-4019");
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.1 ");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows : Microsoft Bulletins");
  script_name(english:"Microsoft Excel Remote Code Execution Vulnerability (956416)");
  script_summary(english:"Check for Microsoft Excel file version");
  desc["english"] = "
  MS08-057

  Overview: This host is missing critical security update according to
  Microsoft Bulletin MS08-057.

  Vulnerability Insight:
  The flaws are caused due to,
  - insufficient validation of data in a VBA Performance Cache.
  - an error in the loading of Excel objects, which in corrupt memory via
    a specially crafted file.
  - an integer overflow in the REPT function when handling formulas inside
    cells.

  Impact: Remote attackers could corrupt memory via a specially
  crafted Excel (.xls) files.

  Impact Level: System

  Affected Software/OS:
  Microsoft Execel 2002/XP/2003/2007 on Windows (All).
  Microsoft Execel Viewer 2003/2007 on Windows (All).

  Fix: Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms08-057.mspx

  References: http://www.microsoft.com/technet/security/bulletin/ms08-057.mspx

  CVSS Score:
    CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
    CVSS Temporal Score : 6.1
  Risk factor : High";

  script_description(english:desc["english"]);
  script_dependencies("secpod_office_products_version_900032.nasl",
                      "secpod_ms_office_detection_900025.nasl");
  script_require_keys("SMB/WindowsVersion", "SMB/Office/Excel/Version");
  exit(0);
}


include("version_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(egrep(pattern:"^(9|10|11|12)\..*", string:get_kb_item("MS/Office/Ver")))
{
  excelVer = get_kb_item("SMB/Office/Excel/Version");
  if(!excelVer){
    exit(0);
  }

  if(version_in_range(version:excelVer, test_version:"9.0",
                      test_version2:"9.0.0.8971")){
    security_hole(0);
  }
  else if(version_in_range(version:excelVer, test_version:"10.0",
                           test_version2:"10.0.6846")){
    security_hole(0);
  }
  else if(version_in_range(version:excelVer, test_version:"11.0",
                           test_version2:"11.0.8230")){
    security_hole(0);
  }
  else if(version_in_range(version:excelVer, test_version:"12.0",
                           test_version2:"12.0.6324.5000")){
    security_hole(0);
  }
}
