###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_iis_detect.nasl 2386 2009-05-19 12:54:36Z may $
#
# Microsoft IIS Webserver Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900710);
  script_version("Revision: 1.0 ");
  script_name(english:"Microsoft IIS Webserver Version Detection");
  desc["english"] = "

  Overview: This script detects the installed MS IIS Webserver and sets the
  result in KB.

  Risk factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set the Version of Microsoft IIS in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

iisPort = get_http_port(default:80);
if(!iisPort){
  iisPort = 80;
}

if(!get_port_state(iisPort)){
  exit(0);
}

request = http_get(item:string("/"), port:iisPort);
response = http_send_recv(port:iisPort, data:request);

if("Microsoft-IIS" >!< response){
  exit(0);
}

iisVer = eregmatch(pattern:"IIS\/([0-9.]+)", string:response);
if(iisVer[1] != NULL){
  # KB for Internet Information Service (IIS)
  set_kb_item(name:"IIS/" + iisPort + "/Ver", value:iisVer[1]);
}
