##############################################################################
#
#  Opera Version Detection for Linux
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/21
#
#  Revision: 1.3
#
#  Log: schandan
#  Issue #0136
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
 script_id(900037);
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.3 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"General");
 script_name(english:"Opera Version Detection for Linux");
 script_summary(english:"Set File Version of Opera in KB");
 desc["english"] ="
 Overview : This script finds the Opera Web browser installed version on
 Linux and saves the version in KB.

 Risk factor : Informational";
 script_description(english:desc["english"]);
 exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

grep = find_bin(prog_name:"grep", sock:sock);
grep = chomp(grep[0]);

garg[0] = "-o";
garg[1] = "-m1";
garg[2] = "-a";
garg[3] = string("Opera [0-9]\\.[0-9]\\+");

operaName = find_file(file_name:"opera", file_path:"/", useregex:TRUE,
                      regexpar:"$", sock:sock);
foreach binaryName(operaName)
{
  binaryName = chomp(binaryName);
  if(islocalhost())
  {
    garg[4] = binaryName;
    arg = garg;
  }
  else
  {
    arg = garg[0] + " " + garg[1] + " " + garg[2] + " " + raw_string(0x22) +
          garg[3] + raw_string(0x22) + " " + binaryName;
  }

  operaVer = get_bin_version(full_prog_name:grep, version_argv:arg,
                             ver_pattern:"Opera ([0-9]\.[0-9]+)", sock:sock);
  if(operaVer)
  {
    set_kb_item(name:"Opera/Linux/Version", value:operaVer[1]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
