###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_prochatrooms_dir_trav_n_xss_vuln.nasl 1086 2009-03-30 15:33:29Z mar $
#
# Directory Traversal And XSS Vulnerability In Pro Chat Rooms
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900331);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6501", "CVE-2008-6502");
  script_bugtraq_id(32758);
  script_name(english:"Directory Traversal And XSS Vulnerability In Pro Chat Rooms");
  desc["english"] = "

  Overview: This host is running Pro Chat Rooms and is prone to Directory
  Traversal and XSS vulnerability.

  Vulnerability Insight:
  - Error in profiles/index.php and profiles/admin.php file allows remote
    attackers to inject arbitrary web script or HTML via the 'gud' parameter.
  - Error in sendData.php file allows remote authenticated users to select
    an arbitrary local PHP script as an avatar via a ..(dot dot) in the
    'avatar' parameter.

  Impact:
  Successful exploitation could result in Directory Traversal, Cross-Site
  Scripting or Cross-Site Request Forgery attack by execute arbitrary HTML
  and script code on the affected application.

  Impact Level: Application

  Affected Software/OS:
  Pro Chat Rooms version 3.0.3 and prior on all running platform.

  Fix: No solution or patch is available as on 30th March, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.prochatrooms.com

  References:
  http://secunia.com/advisories/33088
  http://www.milw0rm.com/exploits/6612
  http://www.milw0rm.com/exploits/7409

  CVSS Score:
    CVSS Base Score     : 4.0 (AV:N/AC:L/Au:SI/C:N/I:P/A:N)
    CVSS Temporal Score : 3.6
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version or XSS in Pro Chat Rooms");
  script_category(ACT_MIXED_ATTACK);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Web application abuses");
  script_dependencies("secpod_prochatrooms_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("version_func.inc");
include("http_keepalive.inc");

pcrPort = get_kb_item("Services/www");
if(!pcrPort){
  exit(0);
}

if(!safe_checks())
{
  # XSS attack string test in 'gud' parameter inside 'index.php' and
  # 'admin.php' file
  sndReq = string("GET /prochatrooms/profiles/index.php?gud=XSSED \r\n\r\n");
  rcvRes = http_keepalive_send_recv(port:pcrPort, data:sndReq);
  if(rcvRes == NULL)
  {
    sndReq = string("GET /prochatrooms/profiles/admin.php?gud=XSSED \r\n\r\n");
    rcvRes = http_keepalive_send_recv(port:pcrPort, data:sndReq);
    if(rcvRes == NULL){
      exit(0);
    }
  }

  if("XSSED" >< rcvRes)
  {
    security_warning(pcrPort);
    exit(0);
  }
}

pcrVer = get_kb_item("www/"+ pcrPort + "/ProChatRooms");
if(!pcrVer){
  exit(0);
}

# Check for version 3.0.3 and prior
if(version_is_less_equal(version:pcrVer, test_version:"3.0.3")){
  security_warning(pcrPort);
}
