##############################################################################
#
#  Python Multiple Vulnerabilities (Linux) 
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/05
#
#  Revision: 1.4
#
#  Log: ssharath
#  Issue #0091
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900106);
 script_bugtraq_id(30491);
 script_cve_id("CVE-2008-2315", "CVE-2008-2316", "CVE-2008-3142",
		"CVE-2008-3143","CVE-2008-3144");
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.4 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Misc.");
 script_name(english:"Python Multiple Vulnerabilities (Linux)");
 script_summary(english:"Check for vulnerable version of Pyhton");
 desc["english"] = "
 Overview : The host is installed Python, which is prone to multiple vulnerabilities.
        
 Vulnerability Insight :
 
        The flaws exists due to integer overflow in,
        - hashlib module, which can lead to an unreliable cryptographic digest 
          results.
        - the processing of unicode strings.
        - the PyOS_vsnprintf() function on architectures that do not have a 
          vsnprintf() function.
        - the PyOS_vsnprintf() function when passing zero-length strings can 
          lead to memory corruption.

        Impact : Successful exploitation could potentially causes attackers to 
        execute arbitrary code or create a denial of service condition. 

 Impact Level : Application
 
 Affected Software/OS :
        Python 2.5.2 and prior on Linux (All).

 Fix : Fix is available in the SVN repository,
 http://svn.python.org
 
 References :
 http://bugs.python.org/issue2588
 http://bugs.python.org/issue2589
 http://bugs.python.org/issue2620

 CVSS Score :
        CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
        CVSS Temporal Score : 5.0
 Risk factor : Medium";
 script_description(english:desc["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/uname");
 exit(0);
}


 include("ssh_func.inc");

 if("Linux" >!< get_kb_item("ssh/login/uname")){
        exit(0);
 }

 foreach item (get_kb_list("ssh/*/rpms"))
 {
        if("python" >< item)
        {
                if(egrep(pattern:"python-.*~([01]\..*|2\.([0-4]\..*|5\.[0-2]))[^.0-9]",
			 string:item)){
                        security_warning(0); 
                }
		exit(0);
        }
 }

 sock = ssh_login_or_reuse_connection();
 if(!sock){
        exit(0);
 }

 pyVer = ssh_cmd(socket:sock, cmd:"python -V", timeout:timeout);
 ssh_close_connection();

 if(!pyVer){
        exit(0);
 }

 if(egrep(pattern:"^Python ([01]\..*|2\.([0-4]\..*|5\.[0-2]))$", string:pyVer)){
        security_warning(0);
 }
