#############################################################################
#
#  Enumerates List of Windows Hotfixes 
#
#  Copyright: SecPod
#
#  Date Written: 2008/07/21
#
#  Revision: 1.1
#
#  Log: schandan
#  Issue #
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
 script_id(900012);
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
 script_category(ACT_GATHER_INFO);
 script_name(english:"Enumerates List of Windows Hotfixes");
 script_family(english:"Windows");
 script_summary(english:"Check for Hotfixes and set KB List");
 desc["english"] = "
 Overview :  This script will enumerates the list of all installed hotfixes
 on the remote host and sets Knowledge Base.

 Risk factor : Informational";
 script_description(english:desc["english"]);
 script_dependencies("netbios_name_get.nasl", "smb_login.nasl",
		     "smb_registry_access.nasl", "smb_reg_service_pack.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
		     "SMB/registry_access");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");

 if(get_kb_item("SMB/samba")){
	exit(0);
 }

 if(get_kb_item("SMB/Registry/Enumerated")){
	exit(0);
 }

 global_var handle;

 function crawlLevel(key, level, maxlevel)
 {
 	list = make_list();
	
	if(level >= maxlevel){
		return list;
	}

 	key_h = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe,
				 key:key, reply:handle);
	if(key_h)
	{
		entries = registry_enum_key(soc:soc, uid:uid, tid:tid,
					    pipe:pipe, reply:key_h);
		registry_close(soc:soc, uid:uid, tid:tid, pipe:pipe,
			       reply:key_h);
 	}

 	foreach item (entries){
		list = make_list(list, key + "\" + item);
  	}
 	return list;
 }

 function crawl(key, level, maxlevel)
 {
	enum = make_list();

	if(level >= maxlevel){
                return enum;
        }

	enumList = crawlLevel(key, level, maxlevel);
	if(max_index(enumList) > 0){
		enum = make_list(enum, enumList);
	}

        foreach item (enumList)
        {
                listLevel1 = crawlLevel(key:item, level:level+1, maxlevel:maxlevel);
                if(max_index(listLevel1) > 0){
			enum = make_list(enum, listLevel1);
		}

                foreach item (listLevel1)
                {
                        listLevel2 = crawlLevel(key:item, level:level+1, maxlevel:maxlevel);
                        if(max_index(listLevel2) > 0){
				enum = make_list(enum, listLevel2);
			}
                }
        }
        return enum;
 }


 name = kb_smb_name();
 if(!name){
	exit(0);
 }

 port = kb_smb_transport();
 if(!port){
	exit(0);
 }

 if(!get_port_state(port)){
	exit(0);
 }

 login  = kb_smb_login();
 pass   = kb_smb_password();
 domain = kb_smb_domain();

 if(!login){
	login = "";
 }
 if(!pass){
	pass = "";
 }

 soc = open_sock_tcp(port);
 if(!soc){
	exit(0);
 }

 r = smb_session_request(soc:soc, remote:name);
 if(!r)
 {
	close(soc);
	exit(0);
 }

 prot = smb_neg_prot(soc:soc);
 if(!prot)
 {
 	close(soc);
	exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain,
		       prot:prot);
 if(!r)
 {
	close(soc);
	exit(0);
 }
 uid = session_extract_uid(reply:r);

 r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");
 tid = tconx_extract_tid(reply:r);
 if(!tid)
 {
	close(soc);
	exit(0);
 }

 r = smbntcreatex(soc:soc, uid:uid, tid:tid, name:"\winreg");
 if(!r)
 {
	close(soc);
	exit(0);
 }

 pipe = smbntcreatex_extract_pipe(reply:r);
 r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
 if(!r)
 {
	close(soc);
	exit(0);
 }

 handle = registry_open_hklm(soc:soc, uid:uid, tid:tid, pipe:pipe);
 location1 = "SOFTWARE\Microsoft\Updates";
 location2 = "SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix";

 list = make_list(crawl(key:location1, level:0, maxlevel:3), 
                  crawl(key:location2, level:0, maxlevel:1));
		 
 if(max_index(list) > 0){
 	set_kb_item(name:"SMB/Registry/Enumerated", value:TRUE);
 }

 foreach item ( list )
 {
	if(egrep(pattern:"\\(KB|Q|M)[0-9]+", string:item))
	{
 		item = str_replace(find:"\", replace:"/", string:item);
 		name = "SMB/Registry/HKLM/" + item;
 		set_kb_item(name:name, value:TRUE);
	}
 }
