##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_servu_ftp_server_detect.nasl 1063 2009-03-23 12:00:24Z mar $
#
# Rhinosoft Serv-U FTP Server Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http//www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900482);
  script_version("$Revision: 1.0 $");
  script_name(english:"Rhinosoft Serv-U FTP Server Version Detection");
  desc["english"] = "
  Overview : This script finds the installed Rhinosoft Serv-U FTP Server and
  saves the version in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set Version of Rhinosoft Serv-U FTP Server in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"General");
  script_dependencies("secpod_reg_enum.nasl", "find_service.nes");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\Serv-U";
if(!registry_key_exists(key:key)){
  exit(0);
}

path = registry_get_sz(key:key, item:"Path");
if(path != NULL)
{
  path = path + "\Serv-U.exe";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:path);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:path);
  version = GetVer(file: file, share:share);
  set_kb_item(name:"Serv-U/FTPServ/Ver", value:version);
}
