###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_symantec_pcanywhere_dos_vuln.nasl 1022 2009-03-26 20:41:29Z mar $
#
# Symantec pcAnywhere Format String DoS Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900333);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0538");
  script_bugtraq_id(33845);
  script_name(english:"Symantec pcAnywhere Format String DoS Vulnerability");
  desc["english"] = "

  Overview: This host is installed with Symantec pcAnywhere and is prone
  to denial of service vulnerability.

  Vulnerability Insight:
  Issue exists due to improper processing of format strings within '.CHF'
  remote control file names or associated file path.

  Impact:
  Allows a malicious user to crash an affected application, creating a denial
  of service condition.

  Impact Level: Application

  Affected Software/OS:
  Symantec pcAnywhere version 12.5 and prior on Windows.

  Fix: Upgrade to pcAnywhere version 12.5 SP1
  http://www.symantec.com/norton/symantec-pcanywhere

  References:
  http://secunia.com/advisories/34305
  http://www.layereddefense.com/pcanywhere17mar.html
  http://securityresponse.symantec.com/avcenter/security/Content/2009.03.17.html

  CVSS Score:
    CVSS Base Score     : 4.6 (AV:L/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Symantec pcAnywhere");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Denial of Service");
  script_dependencies("secpod_symantec_prdts_detect.nasl");
  script_require_keys("Symantec/pcAnywhere/Ver");
  exit(0);
}


include("version_func.inc");

pcawVer = get_kb_item("Symantec/pcAnywhere/Ver");
if(!pcawVer){
  exit(0);
}

# Check for Symantec pcAnywhere version <= 12.5 (12.5.0.442)
if(version_is_less_equal(version:pcawVer, test_version:"12.5.0.442")){
  security_warning(0);
}
