###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_thunderbird_mult_vuln_feb09_lin.nasl 986 2009-02-17 18:11:26Z feb $
#
# Mozilla Thunderbird Multiple Vulnerabilities Feb-09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900311);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0352", "CVE-2009-0353");
  script_bugtraq_id(33598);
  script_name(english:"Mozilla Thunderbird Multiple Vulnerabilities Feb-09 (Linux)");
  desc["english"] = "

  Overview: The host is installed with Mozilla Thunderbird and is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  Flaws are in vectors related to the layout engine and destruction of
  arbitrary layout objects by the 'nsViewManager::Composite' function.

  Impact:
  Successful exploitation may let the attacker cause remote code execution
  or may cause memory/application crash to conduct denial of service attack.

  Impact Level: System/Application

  Affected Software/OS:
  Thunderbird version prior to 2.0.0.21 on Linux.

  Fix: Upgrade to Thunderbird version 2.0.0.21
  http://www.mozilla.com/en-US/thunderbird

  References:
  http://secunia.com/advisories/33799
  http://www.mozilla.org/security/announce/2009/mfsa2009-01.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Thunderbird");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Denial of Service");
  script_dependencies("gb_thunderbird_detect_lin.nasl");
  script_require_keys("Thunderbird/Linux/Ver");
  exit(0);
}


include("version_func.inc");

tbVer = get_kb_item("Thunderbird/Linux/Ver");
if(!tbVer){
  exit(0);
}

# Grep for Thunderbird version < 2.0.0.21
if(version_is_less(version:tbVer, test_version:"2.0.0.21")){
  security_hole(0);
}
